/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;

public class BuilderOptions {
    public static final String DEFAULT_CONFIG_FILENAME = "modpack.json";
    public static final String DEFAULT_VERSION_FILENAME = "version.json";
    public static final String DEFAULT_SRC_DIRNAME = "src";
    public static final String DEFAULT_LOADERS_DIRNAME = "loaders";
    @Parameter(names={"--name"})
    private String name;
    @Parameter(names={"--title"})
    private String title;
    @Parameter(names={"--mc-version"})
    private String gameVersion;
    @Parameter(names={"--version"}, required=true)
    private String version;
    @Parameter(names={"--manifest-dest"}, required=true)
    private File manifestPath;
    @Parameter(names={"--input", "-i"})
    private File inputPath;
    @Parameter(names={"--output", "-o"})
    private File outputPath;
    @Parameter(names={"--config"})
    private File configPath;
    @Parameter(names={"--version-file"})
    private File versionManifestPath;
    @Parameter(names={"--files"})
    private File filesDir;
    @Parameter(names={"--loaders"})
    private File loadersDir;
    @Parameter(names={"--objects-dest"})
    private File objectsDir;
    @Parameter(names={"--libraries-dest"})
    private File librariesDir;
    @Parameter(names={"--libs-url"})
    private String librariesLocation = "libraries";
    @Parameter(names={"--objects-url"})
    private String objectsLocation = "objects";
    @Parameter(names={"--pretty-print"})
    private boolean prettyPrinting;

    public void choosePaths() throws ParameterException {
        if (this.configPath == null) {
            this.requireInputPath("--config");
            this.configPath = new File(this.inputPath, DEFAULT_CONFIG_FILENAME);
        }
        if (this.versionManifestPath == null) {
            this.requireInputPath("--version");
            this.versionManifestPath = new File(this.inputPath, DEFAULT_VERSION_FILENAME);
        }
        if (this.filesDir == null) {
            this.requireInputPath("--files");
            this.filesDir = new File(this.inputPath, DEFAULT_SRC_DIRNAME);
        }
        if (this.loadersDir == null) {
            this.requireInputPath("--loaders");
            this.loadersDir = new File(this.inputPath, DEFAULT_LOADERS_DIRNAME);
        }
        if (this.objectsDir == null) {
            this.requireOutputPath("--objects-dest");
            this.objectsDir = new File(this.outputPath, this.objectsLocation);
        }
        if (this.librariesDir == null) {
            this.requireOutputPath("--libs-dest");
            this.librariesDir = new File(this.outputPath, this.librariesLocation);
        }
    }

    private void requireOutputPath(String name) throws ParameterException {
        if (this.outputPath == null) {
            throw new ParameterException("Because " + name + " was not specified, --output needs to be specified as the output directory and then " + name + " will be default to a pre-set path within the output directory");
        }
    }

    private void requireInputPath(String name) throws ParameterException {
        if (this.inputPath == null) {
            throw new ParameterException("Because " + name + " was not specified, --input needs to be specified as the project directory and then " + name + " will be default to a pre-set path within the project directory");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public File getManifestPath() {
        return this.manifestPath;
    }

    public File getInputPath() {
        return this.inputPath;
    }

    public File getOutputPath() {
        return this.outputPath;
    }

    public File getConfigPath() {
        return this.configPath;
    }

    public File getVersionManifestPath() {
        return this.versionManifestPath;
    }

    public File getFilesDir() {
        return this.filesDir;
    }

    public File getLoadersDir() {
        return this.loadersDir;
    }

    public File getObjectsDir() {
        return this.objectsDir;
    }

    public File getLibrariesDir() {
        return this.librariesDir;
    }

    public String getLibrariesLocation() {
        return this.librariesLocation;
    }

    public String getObjectsLocation() {
        return this.objectsLocation;
    }

    public boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setGameVersion(String gameVersion) {
        this.gameVersion = gameVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setManifestPath(File manifestPath) {
        this.manifestPath = manifestPath;
    }

    public void setInputPath(File inputPath) {
        this.inputPath = inputPath;
    }

    public void setOutputPath(File outputPath) {
        this.outputPath = outputPath;
    }

    public void setConfigPath(File configPath) {
        this.configPath = configPath;
    }

    public void setVersionManifestPath(File versionManifestPath) {
        this.versionManifestPath = versionManifestPath;
    }

    public void setFilesDir(File filesDir) {
        this.filesDir = filesDir;
    }

    public void setLoadersDir(File loadersDir) {
        this.loadersDir = loadersDir;
    }

    public void setObjectsDir(File objectsDir) {
        this.objectsDir = objectsDir;
    }

    public void setLibrariesDir(File librariesDir) {
        this.librariesDir = librariesDir;
    }

    public void setLibrariesLocation(String librariesLocation) {
        this.librariesLocation = librariesLocation;
    }

    public void setObjectsLocation(String objectsLocation) {
        this.objectsLocation = objectsLocation;
    }

    public void setPrettyPrinting(boolean prettyPrinting) {
        this.prettyPrinting = prettyPrinting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuilderOptions)) {
            return false;
        }
        BuilderOptions other = (BuilderOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPrettyPrinting() != other.isPrettyPrinting()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$gameVersion = this.getGameVersion();
        String other$gameVersion = other.getGameVersion();
        if (this$gameVersion == null ? other$gameVersion != null : !this$gameVersion.equals(other$gameVersion)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        File this$manifestPath = this.getManifestPath();
        File other$manifestPath = other.getManifestPath();
        if (this$manifestPath == null ? other$manifestPath != null : !((Object)this$manifestPath).equals(other$manifestPath)) {
            return false;
        }
        File this$inputPath = this.getInputPath();
        File other$inputPath = other.getInputPath();
        if (this$inputPath == null ? other$inputPath != null : !((Object)this$inputPath).equals(other$inputPath)) {
            return false;
        }
        File this$outputPath = this.getOutputPath();
        File other$outputPath = other.getOutputPath();
        if (this$outputPath == null ? other$outputPath != null : !((Object)this$outputPath).equals(other$outputPath)) {
            return false;
        }
        File this$configPath = this.getConfigPath();
        File other$configPath = other.getConfigPath();
        if (this$configPath == null ? other$configPath != null : !((Object)this$configPath).equals(other$configPath)) {
            return false;
        }
        File this$versionManifestPath = this.getVersionManifestPath();
        File other$versionManifestPath = other.getVersionManifestPath();
        if (this$versionManifestPath == null ? other$versionManifestPath != null : !((Object)this$versionManifestPath).equals(other$versionManifestPath)) {
            return false;
        }
        File this$filesDir = this.getFilesDir();
        File other$filesDir = other.getFilesDir();
        if (this$filesDir == null ? other$filesDir != null : !((Object)this$filesDir).equals(other$filesDir)) {
            return false;
        }
        File this$loadersDir = this.getLoadersDir();
        File other$loadersDir = other.getLoadersDir();
        if (this$loadersDir == null ? other$loadersDir != null : !((Object)this$loadersDir).equals(other$loadersDir)) {
            return false;
        }
        File this$objectsDir = this.getObjectsDir();
        File other$objectsDir = other.getObjectsDir();
        if (this$objectsDir == null ? other$objectsDir != null : !((Object)this$objectsDir).equals(other$objectsDir)) {
            return false;
        }
        File this$librariesDir = this.getLibrariesDir();
        File other$librariesDir = other.getLibrariesDir();
        if (this$librariesDir == null ? other$librariesDir != null : !((Object)this$librariesDir).equals(other$librariesDir)) {
            return false;
        }
        String this$librariesLocation = this.getLibrariesLocation();
        String other$librariesLocation = other.getLibrariesLocation();
        if (this$librariesLocation == null ? other$librariesLocation != null : !this$librariesLocation.equals(other$librariesLocation)) {
            return false;
        }
        String this$objectsLocation = this.getObjectsLocation();
        String other$objectsLocation = other.getObjectsLocation();
        return !(this$objectsLocation == null ? other$objectsLocation != null : !this$objectsLocation.equals(other$objectsLocation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuilderOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrettyPrinting() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $gameVersion = this.getGameVersion();
        result = result * 59 + ($gameVersion == null ? 43 : $gameVersion.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        File $manifestPath = this.getManifestPath();
        result = result * 59 + ($manifestPath == null ? 43 : ((Object)$manifestPath).hashCode());
        File $inputPath = this.getInputPath();
        result = result * 59 + ($inputPath == null ? 43 : ((Object)$inputPath).hashCode());
        File $outputPath = this.getOutputPath();
        result = result * 59 + ($outputPath == null ? 43 : ((Object)$outputPath).hashCode());
        File $configPath = this.getConfigPath();
        result = result * 59 + ($configPath == null ? 43 : ((Object)$configPath).hashCode());
        File $versionManifestPath = this.getVersionManifestPath();
        result = result * 59 + ($versionManifestPath == null ? 43 : ((Object)$versionManifestPath).hashCode());
        File $filesDir = this.getFilesDir();
        result = result * 59 + ($filesDir == null ? 43 : ((Object)$filesDir).hashCode());
        File $loadersDir = this.getLoadersDir();
        result = result * 59 + ($loadersDir == null ? 43 : ((Object)$loadersDir).hashCode());
        File $objectsDir = this.getObjectsDir();
        result = result * 59 + ($objectsDir == null ? 43 : ((Object)$objectsDir).hashCode());
        File $librariesDir = this.getLibrariesDir();
        result = result * 59 + ($librariesDir == null ? 43 : ((Object)$librariesDir).hashCode());
        String $librariesLocation = this.getLibrariesLocation();
        result = result * 59 + ($librariesLocation == null ? 43 : $librariesLocation.hashCode());
        String $objectsLocation = this.getObjectsLocation();
        result = result * 59 + ($objectsLocation == null ? 43 : $objectsLocation.hashCode());
        return result;
    }

    public String toString() {
        return "BuilderOptions(name=" + this.getName() + ", title=" + this.getTitle() + ", gameVersion=" + this.getGameVersion() + ", version=" + this.getVersion() + ", manifestPath=" + this.getManifestPath() + ", inputPath=" + this.getInputPath() + ", outputPath=" + this.getOutputPath() + ", configPath=" + this.getConfigPath() + ", versionManifestPath=" + this.getVersionManifestPath() + ", filesDir=" + this.getFilesDir() + ", loadersDir=" + this.getLoadersDir() + ", objectsDir=" + this.getObjectsDir() + ", librariesDir=" + this.getLibrariesDir() + ", librariesLocation=" + this.getLibrariesLocation() + ", objectsLocation=" + this.getObjectsLocation() + ", prettyPrinting=" + this.isPrettyPrinting() + ")";
    }
}

