/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.skcraft.launcher.builder.ClientFileCollector;
import com.skcraft.launcher.builder.DirectoryWalker;
import com.skcraft.launcher.builder.FeaturePattern;
import com.skcraft.launcher.builder.FileInfo;
import com.skcraft.launcher.builder.FnMatch;
import com.skcraft.launcher.builder.FnPatternList;
import com.skcraft.launcher.model.modpack.Feature;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class FileInfoScanner
extends DirectoryWalker {
    private static final Logger log = Logger.getLogger(FileInfoScanner.class.getName());
    private static final EnumSet<FnMatch.Flag> MATCH_FLAGS = EnumSet.of(FnMatch.Flag.CASEFOLD, FnMatch.Flag.PERIOD, FnMatch.Flag.PATHNAME);
    public static final String FILE_SUFFIX = ".info.json";
    private final ObjectMapper mapper;
    private final List<FeaturePattern> patterns = new ArrayList<FeaturePattern>();

    public FileInfoScanner(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    protected DirectoryWalker.DirectoryBehavior getBehavior(String name) {
        return ClientFileCollector.getDirectoryBehavior(name);
    }

    @Override
    protected void onFile(File file, String relPath) throws IOException {
        if (file.getName().endsWith(FILE_SUFFIX)) {
            String fnPattern = FilenameUtils.separatorsToUnix(FilenameUtils.getPath(relPath)) + FilenameUtils.getBaseName(FilenameUtils.getBaseName(file.getName())) + "*";
            FileInfo info = this.mapper.readValue(file, FileInfo.class);
            Feature feature = info.getFeature();
            if (feature != null) {
                Preconditions.checkNotNull(Strings.emptyToNull(feature.getName()), "Empty component name found in " + file.getAbsolutePath());
                ArrayList<String> patterns = new ArrayList<String>();
                patterns.add(fnPattern);
                FnPatternList patternList = new FnPatternList();
                patternList.setInclude(patterns);
                patternList.setFlags(MATCH_FLAGS);
                FeaturePattern fp = new FeaturePattern();
                fp.setFeature(feature);
                fp.setFilePatterns(patternList);
                this.getPatterns().add(fp);
                log.info("Found .info.json file at " + file.getAbsolutePath() + ", with pattern " + fnPattern + ", and component " + feature);
            }
        }
    }

    public List<FeaturePattern> getPatterns() {
        return this.patterns;
    }
}

