/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder;

import com.skcraft.launcher.builder.FeaturePattern;
import com.skcraft.launcher.builder.FnPatternList;
import com.skcraft.launcher.model.modpack.Condition;
import com.skcraft.launcher.model.modpack.Feature;
import com.skcraft.launcher.model.modpack.FileInstall;
import com.skcraft.launcher.model.modpack.Manifest;
import com.skcraft.launcher.model.modpack.ManifestEntry;
import com.skcraft.launcher.model.modpack.RequireAny;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PropertiesApplicator {
    private final Manifest manifest;
    private final Set<Feature> used = new HashSet<Feature>();
    private final List<FeaturePattern> features = new ArrayList<FeaturePattern>();
    private FnPatternList userFiles;

    public PropertiesApplicator(Manifest manifest) {
        this.manifest = manifest;
    }

    public void apply(ManifestEntry entry) {
        if (entry instanceof FileInstall) {
            this.apply((FileInstall)entry);
        }
    }

    private void apply(FileInstall entry) {
        String path = entry.getTargetPath();
        entry.setWhen(this.fromFeature(path));
        entry.setUserFile(this.isUserFile(path));
    }

    public boolean isUserFile(String path) {
        if (this.userFiles != null) {
            return this.userFiles.matches(path);
        }
        return false;
    }

    public Condition fromFeature(String path) {
        ArrayList<Feature> found = new ArrayList<Feature>();
        for (FeaturePattern pattern : this.features) {
            if (!pattern.matches(path)) continue;
            this.used.add(pattern.getFeature());
            found.add(pattern.getFeature());
        }
        if (!found.isEmpty()) {
            return new RequireAny(found);
        }
        return null;
    }

    public void register(FeaturePattern component) {
        this.features.add(component);
    }

    public List<Feature> getFeaturesInUse() {
        return new ArrayList<Feature>(this.used);
    }

    public FnPatternList getUserFiles() {
        return this.userFiles;
    }

    public void setUserFiles(FnPatternList userFiles) {
        this.userFiles = userFiles;
    }
}

