/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.builder.loaders;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Closer;
import com.skcraft.launcher.builder.BuilderUtils;
import com.skcraft.launcher.builder.loaders.ILoaderProcessor;
import com.skcraft.launcher.builder.loaders.LoaderResult;
import com.skcraft.launcher.model.loader.FabricMod;
import com.skcraft.launcher.model.loader.QuiltMod;
import com.skcraft.launcher.model.loader.Versionable;
import com.skcraft.launcher.model.minecraft.Library;
import com.skcraft.launcher.model.minecraft.VersionManifest;
import com.skcraft.launcher.model.modpack.Manifest;
import com.skcraft.launcher.util.HttpRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class FabricLoaderProcessor
implements ILoaderProcessor {
    private static final Logger log = Logger.getLogger(FabricLoaderProcessor.class.getName());
    private final Variant variant;

    @Override
    public LoaderResult process(File loaderJar, Manifest manifest, ObjectMapper mapper, File baseDir) throws IOException {
        JarFile jarFile = new JarFile(loaderJar);
        LoaderResult result = new LoaderResult();
        Closer closer = Closer.create();
        try {
            ZipEntry modEntry = BuilderUtils.getZipEntry(jarFile, this.variant.modJsonName);
            if (modEntry == null) {
                log.warning(String.format("%s loader has no '%s' file, is it really a %s Loader jar?", this.variant.friendlyName, this.variant.modJsonName, this.variant.friendlyName));
                LoaderResult reader = null;
                return reader;
            }
            InputStreamReader reader = new InputStreamReader(jarFile.getInputStream(modEntry));
            Versionable loaderMod = (Versionable)mapper.readValue(BuilderUtils.readStringFromStream(closer.register(reader)), this.variant.mappedClass);
            log.info(String.format("Downloading %s metadata...", this.variant.friendlyName));
            URL metaUrl = HttpRequest.url(String.format(this.variant.metaUrl, manifest.getGameVersion(), loaderMod.getVersion()));
            VersionManifest fabricManifest = HttpRequest.get(metaUrl).execute().expectResponseCode(200).returnContent().asJson(VersionManifest.class);
            for (Library library : fabricManifest.getLibraries()) {
                if (library.getName().startsWith("org.quiltmc:hashed") && loaderMod instanceof QuiltMod) continue;
                result.getLoaderLibraries().add(library);
                log.info("Adding loader library " + library.getName());
            }
            String mainClass = fabricManifest.getMainClass();
            if (mainClass != null) {
                manifest.getVersionManifest().setMainClass(mainClass);
                log.info("Using main class " + mainClass);
            }
        }
        catch (InterruptedException e) {
            log.warning(String.format("HTTP request to %s metadata API was interrupted!", this.variant.friendlyName));
            throw new IOException(e);
        }
        finally {
            closer.close();
            jarFile.close();
        }
        return result;
    }

    public FabricLoaderProcessor(Variant variant) {
        this.variant = variant;
    }

    public static enum Variant {
        FABRIC("Fabric", "fabric.mod.json", "https://meta.fabricmc.net/v2/versions/loader/%s/%s/profile/json", FabricMod.class),
        QUILT("Quilt", "quilt.mod.json", "https://meta.quiltmc.org/v3/versions/loader/%s/%s/profile/json", QuiltMod.class);

        private final String friendlyName;
        private final String modJsonName;
        private final String metaUrl;
        private final Class<? extends Versionable> mappedClass;

        private Variant(String friendlyName, String modJsonName, String metaUrl, Class<? extends Versionable> mappedClass) {
            this.friendlyName = friendlyName;
            this.modJsonName = modJsonName;
            this.metaUrl = metaUrl;
            this.mappedClass = mappedClass;
        }
    }
}

