/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.controller;

import com.skcraft.launcher.creator.dialog.ManifestEntryDialog;
import com.skcraft.launcher.creator.model.creator.ManifestEntry;
import com.skcraft.launcher.swing.SwingHelper;

public class ManifestEntryController {
    private final ManifestEntryDialog dialog;
    private final ManifestEntry manifestEntry;
    private boolean save;

    public ManifestEntryController(ManifestEntryDialog dialog, ManifestEntry manifestEntry) {
        this.dialog = dialog;
        this.manifestEntry = manifestEntry;
        this.initListeners();
        this.copyFrom();
    }

    private void copyFrom() {
        this.dialog.getIncludeCheck().setSelected(this.manifestEntry.isSelected());
        this.dialog.getPrioritySpinner().setValue(this.manifestEntry.getManifestInfo().getPriority());
        SwingHelper.setTextAndResetCaret(this.dialog.getGameKeysText(), SwingHelper.listToLines(this.manifestEntry.getGameKeys()));
    }

    private void copyTo() {
        this.manifestEntry.setSelected(this.dialog.getIncludeCheck().isSelected());
        this.manifestEntry.getManifestInfo().setPriority((Integer)this.dialog.getPrioritySpinner().getValue());
        this.manifestEntry.setGameKeys(SwingHelper.linesToList(this.dialog.getGameKeysText().getText()));
    }

    public boolean show() {
        this.dialog.setVisible(true);
        return this.save;
    }

    private void initListeners() {
        this.dialog.getOkButton().addActionListener(e -> {
            this.copyTo();
            this.save = true;
            this.dialog.dispose();
        });
        this.dialog.getCancelButton().addActionListener(e -> this.dialog.dispose());
    }
}

