/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.controller;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.skcraft.concurrency.Deferred;
import com.skcraft.concurrency.Deferreds;
import com.skcraft.concurrency.SettableProgress;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.InstanceList;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.auth.OfflineSession;
import com.skcraft.launcher.auth.Session;
import com.skcraft.launcher.builder.BuilderConfig;
import com.skcraft.launcher.builder.FnPatternList;
import com.skcraft.launcher.creator.Creator;
import com.skcraft.launcher.creator.controller.GenerateListingController;
import com.skcraft.launcher.creator.controller.VersionCheckController;
import com.skcraft.launcher.creator.controller.task.DirectoryDeleter;
import com.skcraft.launcher.creator.controller.task.ManifestInfoEnumerator;
import com.skcraft.launcher.creator.controller.task.PackBuilder;
import com.skcraft.launcher.creator.controller.task.PackLoader;
import com.skcraft.launcher.creator.controller.task.ProblemChecker;
import com.skcraft.launcher.creator.controller.task.ServerDeploy;
import com.skcraft.launcher.creator.controller.task.TestLauncher;
import com.skcraft.launcher.creator.dialog.AboutDialog;
import com.skcraft.launcher.creator.dialog.BuildDialog;
import com.skcraft.launcher.creator.dialog.BuilderConfigDialog;
import com.skcraft.launcher.creator.dialog.DeployServerDialog;
import com.skcraft.launcher.creator.dialog.GenerateListingDialog;
import com.skcraft.launcher.creator.dialog.PackManagerFrame;
import com.skcraft.launcher.creator.dialog.ProblemViewer;
import com.skcraft.launcher.creator.dialog.VersionCheckDialog;
import com.skcraft.launcher.creator.model.creator.CreatorConfig;
import com.skcraft.launcher.creator.model.creator.ManifestEntry;
import com.skcraft.launcher.creator.model.creator.Pack;
import com.skcraft.launcher.creator.model.creator.Problem;
import com.skcraft.launcher.creator.model.creator.Workspace;
import com.skcraft.launcher.creator.model.swing.PackTableModel;
import com.skcraft.launcher.creator.server.TestServer;
import com.skcraft.launcher.creator.server.TestServerBuilder;
import com.skcraft.launcher.creator.swing.PackDirectoryFilter;
import com.skcraft.launcher.dialog.AccountSelectDialog;
import com.skcraft.launcher.dialog.ConfigurationDialog;
import com.skcraft.launcher.dialog.ConsoleFrame;
import com.skcraft.launcher.dialog.InstanceSettingsDialog;
import com.skcraft.launcher.dialog.ProgressDialog;
import com.skcraft.launcher.model.modpack.LaunchModifier;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.swing.PopupMouseAdapter;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.MorePaths;
import com.skcraft.launcher.util.SwingExecutor;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class PackManagerController {
    private static final DateFormat VERSION_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private static final Pattern FILENAME_SANITIZE = Pattern.compile("[^a-z0-9_\\-\\.]+");
    private final File workspaceDir;
    private final Creator creator;
    private final File workspaceFile;
    private final File dataDir;
    private final File distDir;
    private final File launcherDir;
    private File webRoot;
    private Workspace workspace;
    private final Launcher launcher;
    private final ListeningExecutorService executor;
    private final TestServer testServer;
    private File lastServerDestDir;
    private final PackManagerFrame frame;
    private PackTableModel packTableModel;

    public PackManagerController(PackManagerFrame frame, File workspaceDir, Creator creator) throws IOException {
        this.workspaceDir = workspaceDir;
        this.creator = creator;
        this.dataDir = Workspace.getDataDir(workspaceDir);
        this.workspaceFile = Workspace.getWorkspaceFile(workspaceDir);
        this.distDir = new File(workspaceDir, "_upload");
        this.launcherDir = new File(this.dataDir, "staging/launcher");
        File launcherConfigDir = new File(creator.getDataDir(), "launcher");
        this.webRoot = new File(this.dataDir, "staging/www");
        this.launcherDir.mkdirs();
        launcherConfigDir.mkdirs();
        this.webRoot.mkdirs();
        this.launcher = new Launcher(this.launcherDir, launcherConfigDir);
        this.executor = this.launcher.getExecutor();
        this.frame = frame;
        TestServerBuilder builder = new TestServerBuilder();
        builder.setBaseDir(this.webRoot);
        builder.setPort(0);
        this.testServer = builder.build();
    }

    public void show() {
        this.frame.setVisible(true);
        this.frame.setTitle("Modpack Creator - [" + this.workspaceDir.getAbsolutePath() + "]");
        this.initListeners();
        this.loadWorkspace();
        Deferreds.makeDeferred(this.executor.submit(() -> {
            this.startServer();
            return null;
        })).handle(result -> {}, ex -> SwingHelper.showErrorDialog(this.frame, "Failed to start a local web server. You will be unable to test modpacks.", "Error", ex));
    }

    private void startServer() throws Exception {
        this.testServer.start();
        this.launcher.getProperties().setProperty("newsUrl", "http://localhost:" + this.testServer.getLocalPort() + "/news.html");
        this.launcher.getProperties().setProperty("packageListUrl", "http://localhost:" + this.testServer.getLocalPort() + "/packages.json");
        this.launcher.getProperties().setProperty("selfUpdateUrl", "http://localhost:" + this.testServer.getLocalPort() + "/latest.json");
    }

    private void loadWorkspace() {
        PackLoader loader = new PackLoader();
        SettableProgress progress = new SettableProgress("Loading workspace...", -1.0);
        Deferred deferred = Deferreds.makeDeferred(this.executor.submit(() -> {
            Workspace workspace = Persistence.load(this.workspaceFile, Workspace.class);
            workspace.setDirectory(this.workspaceDir);
            workspace.load();
            if (!this.workspaceFile.exists()) {
                Persistence.commitAndForget(workspace);
            }
            this.workspace = workspace;
            return workspace;
        })).thenTap(() -> progress.observe(loader)).thenApply(loader).thenApplyAsync(packs -> {
            JTable table = this.frame.getPackTable();
            this.packTableModel = new PackTableModel((List<Pack>)packs);
            table.setModel(this.packTableModel);
            this.packTableModel.fireTableDataChanged();
            table.getRowSorter().toggleSortOrder(1);
            if (this.packTableModel.getRowCount() > 0) {
                table.addRowSelectionInterval(0, 0);
            }
            return packs;
        }, SwingExecutor.INSTANCE);
        ProgressDialog.showProgress(this.frame, deferred, progress, "Loading workspace...", "Loading workspace...");
        SwingHelper.addErrorDialogCallback(this.frame, deferred);
    }

    private boolean checkPackLoaded(Pack pack) {
        if (pack.isLoaded()) {
            return true;
        }
        SwingHelper.showErrorDialog(this.frame, "The selected pack could not be loaded. You will have to remove it from the workspace or change its location.", "Error");
        return false;
    }

    public Optional<Pack> getPackFromIndex(int selectedIndex, boolean requireLoaded) {
        Pack pack;
        if (selectedIndex >= 0 && (pack = this.workspace.getPacks().get(selectedIndex)) != null && (!requireLoaded || this.checkPackLoaded(pack))) {
            return Optional.of(pack);
        }
        return Optional.empty();
    }

    public Optional<Pack> getSelectedPack(boolean requireLoaded) {
        JTable table = this.frame.getPackTable();
        int selectedIndex = table.getSelectedRow();
        if (selectedIndex >= 0) {
            selectedIndex = table.convertRowIndexToModel(selectedIndex);
            Pack pack = this.workspace.getPacks().get(selectedIndex);
            if (pack != null && (!requireLoaded || this.checkPackLoaded(pack))) {
                return Optional.of(pack);
            }
        }
        SwingHelper.showErrorDialog(this.frame, "Please select a modpack from the list.", "Error");
        return Optional.empty();
    }

    public boolean writeWorkspace() {
        try {
            Persistence.commit(this.workspace);
            return true;
        }
        catch (IOException e) {
            SwingHelper.showErrorDialog(this.frame, "Failed to write the current state of the workspace to disk. Any recent changes to the list of modpacks may not appear in the workspace on the next load.", "Error", e);
            return false;
        }
    }

    public boolean writeBuilderConfig(Pack pack, BuilderConfig config) {
        try {
            Persistence.write(pack.getConfigFile(), config, Persistence.L2F_LIST_PRETTY_PRINTER);
            return true;
        }
        catch (IOException e) {
            SwingHelper.showErrorDialog(this.frame, "Failed to write modpack.json to disk. Aborting.", "Error", e);
            return false;
        }
    }

    private boolean isOfflineEnabled() {
        CreatorConfig config = this.creator.getConfig();
        if (config.isOfflineEnabled()) {
            return true;
        }
        Session session = AccountSelectDialog.showAccountRequest(this.frame, this.launcher);
        if (session != null) {
            config.setOfflineEnabled(true);
            Persistence.commitAndForget(config);
            return true;
        }
        return false;
    }

    public boolean canAddPackDir(File dir) {
        try {
            if (dir.exists() && !dir.isDirectory()) {
                SwingHelper.showErrorDialog(this.frame, "The selected path is a file that already exists. It must be a directory.", "Error");
                return false;
            }
            if (dir.getCanonicalPath().equals(this.workspaceDir.getCanonicalPath())) {
                SwingHelper.showErrorDialog(this.frame, "You cannot choose the workspace directory.", "Error");
                return false;
            }
            if (this.workspace.hasPack(dir)) {
                SwingHelper.showErrorDialog(this.frame, "There is already a modpack in this workspace that uses that directory.", "Error");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            SwingHelper.showErrorDialog(this.frame, "An unexpected error occurred while checking if the modpack being added can be added.", "Error", e);
            return false;
        }
    }

    public boolean addPackToWorkspace(Pack pack) {
        pack.load();
        try {
            File base = this.workspaceDir;
            File child = pack.getDirectory();
            if (MorePaths.isSubDirectory(base, child)) {
                pack.setLocation(MorePaths.relativize(base, child));
            }
        }
        catch (IOException e) {
            SwingHelper.showErrorDialog(this.frame, "An unexpected error occurred that could have been caused by the removal of the workspace or modpack directory.", "Error", e);
            return false;
        }
        List<Pack> packs = this.workspace.getPacks();
        pack.setWorkspace(this.workspace);
        packs.add(pack);
        this.packTableModel.fireTableRowsInserted(packs.size() - 1, packs.size() - 1);
        this.writeWorkspace();
        return true;
    }

    public void updatePackInWorkspace(Pack pack) {
        List<Pack> packs = this.workspace.getPacks();
        pack.load();
        int index = packs.indexOf(pack);
        if (index >= 0) {
            this.packTableModel.fireTableRowsUpdated(index, index);
        }
        this.writeWorkspace();
    }

    public boolean removePackFromWorkspace(Pack pack) {
        if (this.workspace.getPacks().remove(pack)) {
            this.packTableModel.fireTableDataChanged();
            this.writeWorkspace();
            return true;
        }
        return false;
    }

    private void addDefaultConfig(BuilderConfig config) {
        LaunchModifier launchModifier = new LaunchModifier();
        launchModifier.setFlags(ImmutableList.of("-Dfml.ignoreInvalidMinecraftCertificates=true"));
        config.setLaunchModifier(launchModifier);
        FnPatternList userFiles = new FnPatternList();
        userFiles.setInclude(Lists.newArrayList("options.txt", "optionsshaders.txt"));
        userFiles.setExclude(Lists.newArrayList());
        config.setUserFiles(userFiles);
    }

    private void initListeners() {
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                try {
                    PackManagerController.this.testServer.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        this.frame.getPackTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Optional<Pack> optional;
                Point point;
                JTable table;
                int selectedIndex;
                if (e.getClickCount() == 2 && (selectedIndex = (table = (JTable)e.getSource()).rowAtPoint(point = e.getPoint())) >= 0 && (optional = PackManagerController.this.getPackFromIndex(selectedIndex = table.convertRowIndexToModel(selectedIndex), true)).isPresent()) {
                    if (e.isControlDown()) {
                        SwingHelper.browseDir(optional.get().getDirectory(), PackManagerController.this.frame);
                    } else {
                        PackManagerController.this.startTest(optional.get(), false);
                    }
                }
            }
        });
        this.frame.getPackTable().addMouseListener(new PopupMouseAdapter(){

            @Override
            protected void showPopup(MouseEvent e) {
                Point point;
                JTable table = (JTable)e.getSource();
                int selectedIndex = table.rowAtPoint(point = e.getPoint());
                if (selectedIndex >= 0) {
                    table.setRowSelectionInterval(selectedIndex, selectedIndex);
                    Optional<Pack> optional = PackManagerController.this.getSelectedPack(false);
                    if (optional.isPresent()) {
                        PackManagerController.this.popupPackMenu(e.getComponent(), e.getX(), e.getY(), optional.get());
                    }
                }
            }
        });
        this.frame.getNewPackMenuItem().addActionListener(event -> this.tryAddPackViaDialog());
        this.frame.getNewPackAtLocationMenuItem().addActionListener(e -> this.tryAddPackViaDirectory(true));
        this.frame.getImportPackMenuItem().addActionListener(event -> this.tryAddPackViaDirectory(false));
        this.frame.getRemovePackItem().addActionListener(e -> {
            Pack pack;
            Optional<Pack> optional = this.getSelectedPack(false);
            if (optional.isPresent() && (!(pack = optional.get()).isLoaded() || SwingHelper.confirmDialog(this.frame, "Are you sure that you want to remove this modpack? No files will be deleted and you can later re-import the modpack using 'Add Existing'.", "Confirm"))) {
                this.removePackFromWorkspace(pack);
            }
        });
        this.frame.getDeletePackItem().addActionListener(e -> {
            Optional<Pack> optional = this.getSelectedPack(false);
            if (optional.isPresent()) {
                Pack pack = optional.get();
                String input = JOptionPane.showInputDialog(this.frame, "Are you sure that you want to delete '" + pack.getDirectory().getAbsolutePath() + "'? If yes, type 'delete' below.", "Confirm", 2);
                if (input != null && input.replaceAll("'", "").equalsIgnoreCase("delete")) {
                    this.removePackFromWorkspace(pack);
                    DirectoryDeleter deleter = new DirectoryDeleter(pack.getDirectory());
                    Deferred<File> deferred = Deferreds.makeDeferred(this.executor.submit(deleter), this.executor);
                    ProgressDialog.showProgress(this.frame, deferred, deleter, "Deleting modpack...", "Deleting modpack...");
                    SwingHelper.addErrorDialogCallback(this.frame, deferred);
                } else if (input != null) {
                    SwingHelper.showMessageDialog(this.frame, "You did not enter the correct word. Nothing was deleted.", "Failure", null, 1);
                }
            }
        });
        this.frame.getChangePackLocationMenuItem().addActionListener(e -> {
            Optional<Pack> optional = this.getSelectedPack(false);
            if (optional.isPresent()) {
                Pack pack = optional.get();
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Choose New Folder for Pack");
                chooser.setFileSelectionMode(1);
                chooser.setFileFilter(new PackDirectoryFilter());
                File dir = this.workspaceDir;
                do {
                    chooser.setCurrentDirectory(dir);
                    int returnVal = chooser.showOpenDialog(this.frame);
                    if (returnVal != 0) {
                        return;
                    }
                    dir = chooser.getSelectedFile();
                } while (!this.canAddPackDir(dir));
                pack.setLocation(dir.getAbsolutePath());
                this.updatePackInWorkspace(pack);
            }
        });
        this.frame.getRefreshMenuItem().addActionListener(e -> this.loadWorkspace());
        this.frame.getQuitMenuItem().addActionListener(e -> this.frame.dispose());
        this.frame.getEditConfigMenuItem().addActionListener(e -> {
            Pack pack;
            File file;
            BuilderConfig config;
            Optional<Pack> optional = this.getSelectedPack(true);
            if (optional.isPresent() && BuilderConfigDialog.showEditor(this.frame, config = Persistence.read(file = (pack = optional.get()).getConfigFile(), BuilderConfig.class))) {
                this.writeBuilderConfig(pack, config);
                this.updatePackInWorkspace(pack);
            }
        });
        this.frame.getOpenFolderMenuItem().addActionListener(e -> {
            Optional<Pack> selectedPack = this.getSelectedPack(true);
            selectedPack.ifPresent(pack -> SwingHelper.browseDir(pack.getDirectory(), this.frame));
        });
        this.frame.getCheckProblemsMenuItem().addActionListener(e -> {
            Optional<Pack> optional = this.getSelectedPack(true);
            if (optional.isPresent()) {
                ProblemChecker checker = new ProblemChecker(optional.get());
                Deferred<List> deferred = Deferreds.makeDeferred(this.executor.submit(checker), this.executor).handleAsync(this::showProblems, ex -> {}, SwingExecutor.INSTANCE);
                SwingHelper.addErrorDialogCallback(this.frame, deferred);
            }
        });
        this.frame.getTestMenuItem().addActionListener(e -> {
            Optional<Pack> optional = this.getSelectedPack(true);
            if (optional.isPresent()) {
                Pack pack = optional.get();
                this.startTest(pack, false);
            }
        });
        this.frame.getTestOnlineMenuItem().addActionListener(e -> {
            Optional<Pack> optional = this.getSelectedPack(true);
            if (optional.isPresent()) {
                Pack pack = optional.get();
                this.startTest(pack, true);
            }
        });
        this.frame.getOptionsMenuItem().addActionListener(e -> {
            ConfigurationDialog configDialog = new ConfigurationDialog((Window)this.frame, this.launcher);
            configDialog.setVisible(true);
        });
        this.frame.getInstanceOptionsMenuItem().addActionListener(e -> {
            Optional<Pack> selectedPack = this.getSelectedPack(true);
            selectedPack.ifPresent(pack -> {
                InstanceList.Enumerator instanceList = this.launcher.getInstances().createEnumerator();
                ListenableFuture<InstanceList> future = this.executor.submit(instanceList);
                Futures.addCallback(future, new FutureCallback<InstanceList>(){

                    @Override
                    public void onSuccess(InstanceList result) {
                        Instance found = null;
                        for (Instance instance : result.getInstances()) {
                            if (!instance.getName().equals(pack.getCachedConfig().getName())) continue;
                            found = instance;
                            break;
                        }
                        if (found == null) {
                            SwingHelper.showErrorDialog(PackManagerController.this.frame, "No instance found for that pack - you need to test the pack first.", "Not Found");
                            return;
                        }
                        InstanceSettingsDialog.open(PackManagerController.this.frame, found);
                    }

                    @Override
                    public void onFailure(Throwable ignored) {
                    }
                }, SwingExecutor.INSTANCE);
                ProgressDialog.showProgress(this.frame, future, instanceList, "Enumerating instances...", "Enumerating instances...");
                SwingHelper.addErrorDialogCallback(this.frame, future);
            });
        });
        this.frame.getClearInstanceMenuItem().addActionListener(e -> {
            DirectoryDeleter deleter = new DirectoryDeleter(this.launcher.getInstancesDir());
            Deferred<File> deferred = Deferreds.makeDeferred(this.executor.submit(deleter), this.executor);
            ProgressDialog.showProgress(this.frame, deferred, deleter, "Deleting test instances...", "Deleting test instances...");
            SwingHelper.addErrorDialogCallback(this.frame, deferred);
        });
        this.frame.getClearWebRootMenuItem().addActionListener(e -> {
            DirectoryDeleter deleter = new DirectoryDeleter(this.webRoot);
            Deferred<File> deferred = Deferreds.makeDeferred(this.executor.submit(deleter), this.executor);
            ProgressDialog.showProgress(this.frame, deferred, deleter, "Deleting web server files...", "Deleting web server files...");
            SwingHelper.addErrorDialogCallback(this.frame, deferred);
        });
        this.frame.getBuildMenuItem().addActionListener(e -> {
            Optional<Pack> optional = this.getSelectedPack(true);
            if (optional.isPresent()) {
                Pack pack = optional.get();
                this.buildPack(pack);
            }
        });
        this.frame.getDeployServerMenuItem().addActionListener(e -> {
            Optional<Pack> optional = this.getSelectedPack(true);
            if (optional.isPresent()) {
                Pack pack = optional.get();
                DeployServerDialog.DeployOptions options = DeployServerDialog.showDeployDialog(this.frame, this.lastServerDestDir);
                if (options != null) {
                    ConsoleFrame.showMessages();
                    File destDir = options.getDestDir();
                    destDir.mkdirs();
                    this.lastServerDestDir = destDir;
                    ServerDeploy deploy = new ServerDeploy(pack.getSourceDir(), options);
                    Deferred<ServerDeploy> deferred = Deferreds.makeDeferred(this.executor.submit(deploy), this.executor).handleAsync(r -> SwingHelper.showMessageDialog(this.frame, "Server deployment complete!", "Success", null, 1), ex -> {}, SwingExecutor.INSTANCE);
                    ProgressDialog.showProgress(this.frame, deferred, deploy, "Deploying files...", "Deploying server files...");
                    SwingHelper.addErrorDialogCallback(this.frame, deferred);
                }
            }
        });
        this.frame.getGeneratePackagesMenuItem().addActionListener(e -> {
            List<ManifestEntry> entries = this.workspace.getPackageListingEntries();
            ManifestInfoEnumerator enumerator = new ManifestInfoEnumerator(this.distDir);
            Deferred<List> deferred = Deferreds.makeDeferred(this.executor.submit(() -> enumerator.apply(entries))).handleAsync(loaded -> {
                GenerateListingDialog dialog = new GenerateListingDialog((Window)this.frame);
                GenerateListingController controller = new GenerateListingController(dialog, this.workspace, (List<ManifestEntry>)loaded, this.executor);
                controller.setOutputDir(this.distDir);
                controller.show();
            }, ex -> {}, SwingExecutor.INSTANCE);
            ProgressDialog.showProgress(this.frame, deferred, new SettableProgress("Searching...", -1.0), "Searching for manifests...", "Searching for manifests...");
            SwingHelper.addErrorDialogCallback(this.frame, deferred);
        });
        this.frame.getVersionCheckMenuItem().addActionListener(e -> {
            Optional<Pack> optional = this.getSelectedPack(true);
            if (optional.isPresent()) {
                Pack pack = optional.get();
                VersionCheckDialog dialog = new VersionCheckDialog((Window)this.frame);
                VersionCheckController controller = new VersionCheckController(dialog, this.executor);
                controller.showUpdates(pack.getModsDir(), pack.getCachedConfig().getGameVersion(), this.frame);
            }
        });
        this.frame.getOpenOutputFolderMenuItem().addActionListener(e -> SwingHelper.browseDir(this.distDir, this.frame));
        this.frame.getOpenWorkspaceFolderMenuItem().addActionListener(e1 -> SwingHelper.browseDir(this.workspaceDir, this.frame));
        this.frame.getOpenLauncherFolderMenuItem().addActionListener(e1 -> SwingHelper.browseDir(this.launcherDir, this.frame));
        this.frame.getOpenWebRootMenuItem().addActionListener(e1 -> SwingHelper.browseDir(this.webRoot, this.frame));
        this.frame.getOpenConsoleMenuItem().addActionListener(e -> ConsoleFrame.showMessages());
        this.frame.getDocsMenuItem().addActionListener(e -> SwingHelper.openURL("https://github.com/SKCraft/Launcher/wiki", (Component)this.frame));
        this.frame.getAboutMenuItem().addActionListener(e -> AboutDialog.showAboutDialog(this.frame));
        SwingHelper.addActionListeners(this.frame.getNewPackButton(), this.frame.getNewPackMenuItem().getActionListeners());
        SwingHelper.addActionListeners(this.frame.getImportButton(), this.frame.getImportPackMenuItem().getActionListeners());
        SwingHelper.addActionListeners(this.frame.getEditConfigButton(), this.frame.getEditConfigMenuItem().getActionListeners());
        SwingHelper.addActionListeners(this.frame.getOpenFolderButton(), this.frame.getOpenFolderMenuItem().getActionListeners());
        SwingHelper.addActionListeners(this.frame.getCheckProblemsButton(), this.frame.getCheckProblemsMenuItem().getActionListeners());
        SwingHelper.addActionListeners(this.frame.getTestButton(), this.frame.getTestMenuItem().getActionListeners());
        SwingHelper.addActionListeners(this.frame.getBuildButton(), this.frame.getBuildMenuItem().getActionListeners());
    }

    private void popupPackMenu(Component component, int x, int y, Pack pack) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Edit modpack.json...");
        menuItem.addActionListener(e -> this.frame.getEditConfigMenuItem().doClick());
        popup.add(menuItem);
        menuItem = new JMenuItem("Open Directory");
        menuItem.addActionListener(e -> this.frame.getOpenFolderMenuItem().doClick());
        popup.add(menuItem);
        menuItem = new JMenuItem("Check for Problems");
        menuItem.addActionListener(e -> this.frame.getCheckProblemsMenuItem().doClick());
        popup.add(menuItem);
        popup.addSeparator();
        menuItem = new JMenuItem("Test");
        menuItem.addActionListener(e -> this.frame.getTestMenuItem().doClick());
        popup.add(menuItem);
        menuItem = new JMenuItem("Test Online");
        menuItem.addActionListener(e -> this.frame.getTestOnlineMenuItem().doClick());
        popup.add(menuItem);
        menuItem = new JMenuItem("Instance settings...");
        menuItem.addActionListener(e -> this.frame.getInstanceOptionsMenuItem().doClick());
        popup.add(menuItem);
        menuItem = new JMenuItem("Build...");
        menuItem.addActionListener(e -> this.frame.getBuildMenuItem().doClick());
        popup.add(menuItem);
        menuItem = new JMenuItem("Deploy Server...");
        menuItem.addActionListener(e -> this.frame.getDeployServerMenuItem().doClick());
        popup.add(menuItem);
        popup.addSeparator();
        menuItem = new JMenuItem("Change Location...");
        menuItem.addActionListener(e -> this.frame.getChangePackLocationMenuItem().doClick());
        popup.add(menuItem);
        menuItem = new JMenuItem("Remove...");
        menuItem.addActionListener(e -> this.frame.getRemovePackItem().doClick());
        popup.add(menuItem);
        menuItem = new JMenuItem("Delete Forever...");
        menuItem.addActionListener(e -> this.frame.getDeletePackItem().doClick());
        popup.add(menuItem);
        popup.show(component, x, y);
    }

    private void tryAddPackViaDialog() {
        File dir;
        BuilderConfig config = new BuilderConfig();
        this.addDefaultConfig(config);
        Pack pack = new Pack();
        do {
            if (!BuilderConfigDialog.showEditor(this.frame, config)) {
                return;
            }
            dir = new File(this.workspaceDir, config.getName());
        } while (!this.canAddPackDir(dir));
        pack.setLocation(dir.getAbsolutePath());
        if (pack.getConfigFile().exists()) {
            if (SwingHelper.confirmDialog(this.frame, "There's already an existing modpack with that name, though it is not imported into this workspace. Would you like to import it and ignore the new modpack that you just entered?", "Conflict")) {
                this.addPackToWorkspace(pack);
            }
        } else if (this.writeBuilderConfig(pack, config)) {
            pack.createGuideFolders();
            this.addPackToWorkspace(pack);
        }
    }

    private void tryAddPackViaDirectory(boolean createNew) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Choose Folder for Pack");
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(new PackDirectoryFilter());
        File dir = this.workspaceDir;
        do {
            chooser.setCurrentDirectory(dir);
            int returnVal = chooser.showOpenDialog(this.frame);
            if (returnVal != 0) {
                return;
            }
            dir = chooser.getSelectedFile();
        } while (!this.canAddPackDir(dir));
        Pack pack = new Pack();
        pack.setLocation(dir.getAbsolutePath());
        if (pack.getConfigFile().exists()) {
            if (createNew) {
                if (SwingHelper.confirmDialog(this.frame, "There's already a modpack in that directory. Do you want to import it instead?", "Exists Already")) {
                    this.addPackToWorkspace(pack);
                }
            } else {
                this.addPackToWorkspace(pack);
            }
        } else if (createNew || SwingHelper.confirmDialog(this.frame, "You've selected a directory that doesn't seem to be a modpack (at least with the directory structure this program expects). Would you like to create the files necessary to turn that folder into a modpack?", "Import Error")) {
            BuilderConfig config = new BuilderConfig();
            this.addDefaultConfig(config);
            if (BuilderConfigDialog.showEditor(this.frame, config) && this.writeBuilderConfig(pack, config)) {
                pack.createGuideFolders();
                this.addPackToWorkspace(pack);
            }
        }
    }

    private void startTest(Pack pack, boolean online) {
        Session session;
        if (online) {
            session = AccountSelectDialog.showAccountRequest(this.frame, this.launcher);
            if (session == null) {
                return;
            }
        } else {
            if (!this.isOfflineEnabled()) {
                return;
            }
            session = new OfflineSession("Player");
        }
        String version = PackManagerController.generateVersionFromDate();
        PackBuilder builder = new PackBuilder(pack, this.webRoot, version, "staging.json", false, false);
        InstanceList.Enumerator enumerator = this.launcher.getInstances().createEnumerator();
        TestLauncher instanceLauncher = new TestLauncher(this.launcher, this.frame, pack.getCachedConfig().getName(), session);
        SettableProgress progress = new SettableProgress(builder);
        ConsoleFrame.showMessages();
        Deferred<Instance> deferred = Deferreds.makeDeferred(this.executor.submit(builder), this.executor).thenTap(() -> progress.set("Loading instance in test launcher...", -1.0)).thenRun(enumerator).thenTap(() -> progress.set("Launching", -1.0)).thenApply(instanceLauncher).handleAsync(result -> ConsoleFrame.hideMessages(), ex -> {}, SwingExecutor.INSTANCE);
        ProgressDialog.showProgress(this.frame, deferred, progress, "Setting up test instance...", "Preparing files for launch...");
        SwingHelper.addErrorDialogCallback(this.frame, deferred);
    }

    private void buildPack(Pack pack) {
        String initialVersion = PackManagerController.generateVersionFromDate();
        BuildDialog.BuildOptions options = BuildDialog.showBuildDialog(this.frame, initialVersion, this.generateManifestName(pack), this.distDir);
        if (options != null) {
            ConsoleFrame.showMessages();
            PackBuilder builder = new PackBuilder(pack, options.getDestDir(), options.getVersion(), options.getManifestFilename(), false, true);
            Deferred<PackBuilder> deferred = Deferreds.makeDeferred(this.executor.submit(builder), this.executor).handleAsync(result -> {
                ConsoleFrame.hideMessages();
                SwingHelper.showMessageDialog(this.frame, "Successfully generated the package files.", "Success", null, 1);
            }, ex -> {}, SwingExecutor.INSTANCE);
            ProgressDialog.showProgress(this.frame, deferred, builder, "Building modpack...", "Building modpack...");
            SwingHelper.addErrorDialogCallback(this.frame, deferred);
        }
    }

    private void showProblems(List<Problem> problems) {
        if (problems.isEmpty()) {
            SwingHelper.showMessageDialog(this.frame, "No potential problems found!", "Success", null, 1);
        } else {
            ProblemViewer viewer = new ProblemViewer((Window)this.frame, problems);
            viewer.setVisible(true);
        }
    }

    public String generateManifestName(Pack pack) {
        BuilderConfig config;
        File file = pack.getConfigFile();
        if (file.exists() && (config = Persistence.read(file, BuilderConfig.class, true)) != null) {
            String name = Strings.nullToEmpty(config.getName());
            name = name.toLowerCase();
            name = FILENAME_SANITIZE.matcher(name).replaceAll("-");
            if (!(name = name.trim()).isEmpty()) {
                return name + ".json";
            }
        }
        return "my_modpack.json";
    }

    public static String generateVersionFromDate() {
        Date today = Calendar.getInstance().getTime();
        return VERSION_DATE_FORMAT.format(today);
    }

    public File getWorkspaceDir() {
        return this.workspaceDir;
    }

    public Creator getCreator() {
        return this.creator;
    }

    public File getWorkspaceFile() {
        return this.workspaceFile;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getDistDir() {
        return this.distDir;
    }

    public File getLauncherDir() {
        return this.launcherDir;
    }

    public File getWebRoot() {
        return this.webRoot;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public ListeningExecutorService getExecutor() {
        return this.executor;
    }

    public TestServer getTestServer() {
        return this.testServer;
    }
}

