/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.controller.task;

import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.LauncherException;
import com.skcraft.launcher.LauncherUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class DirectoryDeleter
implements Callable<File>,
ProgressObservable {
    private final File dir;

    public DirectoryDeleter(File dir) {
        this.dir = dir;
    }

    @Override
    public File call() throws Exception {
        Thread.sleep(2000L);
        ArrayList<File> failures = new ArrayList<File>();
        try {
            LauncherUtils.interruptibleDelete(this.dir, failures);
        }
        catch (IOException e) {
            Thread.sleep(1000L);
            LauncherUtils.interruptibleDelete(this.dir, failures);
        }
        if (failures.size() > 0) {
            throw new LauncherException(failures.size() + " failed to delete", failures.size() + " file(s) could not be deleted");
        }
        return this.dir;
    }

    @Override
    public double getProgress() {
        return -1.0;
    }

    @Override
    public String getStatus() {
        return "Deleting files...";
    }
}

