/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.controller.task;

import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.LauncherException;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.builder.PackageBuilder;
import com.skcraft.launcher.creator.model.creator.Pack;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class PackBuilder
implements Callable<PackBuilder>,
ProgressObservable {
    private final Pack pack;
    private final File outputDir;
    private final String version;
    private final String manifestFilename;
    private final boolean clean;
    private final boolean downloadUrls;

    public PackBuilder(Pack pack, File outputDir, String version, String manifestFilename, boolean clean, boolean downloadUrls) {
        this.pack = pack;
        this.outputDir = outputDir;
        this.version = version;
        this.manifestFilename = manifestFilename;
        this.clean = clean;
        this.downloadUrls = downloadUrls;
    }

    @Override
    public PackBuilder call() throws Exception {
        if (this.clean) {
            ArrayList<File> failures = new ArrayList<File>();
            try {
                LauncherUtils.interruptibleDelete(this.outputDir, failures);
            }
            catch (IOException e) {
                Thread.sleep(1000L);
                LauncherUtils.interruptibleDelete(this.outputDir, failures);
            }
            if (failures.size() > 0) {
                throw new LauncherException(failures.size() + " failed to delete", "There were " + failures.size() + " failures during cleaning.");
            }
        }
        this.outputDir.mkdirs();
        System.setProperty("com.skcraft.builder.ignoreURLOverrides", this.downloadUrls ? "false" : "true");
        String[] args = new String[]{"--version", this.version, "--manifest-dest", new File(this.outputDir, this.manifestFilename).getAbsolutePath(), "-i", this.pack.getDirectory().getAbsolutePath(), "-o", this.outputDir.getAbsolutePath()};
        PackageBuilder.main(args);
        return this;
    }

    @Override
    public double getProgress() {
        return -1.0;
    }

    @Override
    public String getStatus() {
        return "Building modpack...";
    }
}

