/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.controller.task;

import com.google.common.base.Function;
import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.creator.model.creator.Pack;
import com.skcraft.launcher.creator.model.creator.Workspace;
import java.util.Iterator;
import java.util.List;

public class PackLoader
implements ProgressObservable,
Function<Workspace, List<Pack>> {
    private int index;
    private int size = 0;
    private Pack lastPack;

    @Override
    public List<Pack> apply(Workspace workspace) {
        List<Pack> packs = workspace.getPacks();
        this.size = packs.size();
        Iterator<Pack> iterator = packs.iterator();
        while (iterator.hasNext()) {
            Pack pack;
            this.lastPack = pack = iterator.next();
            pack.load();
            ++this.index;
        }
        this.lastPack = null;
        return packs;
    }

    @Override
    public double getProgress() {
        if (this.size == 0) {
            return -1.0;
        }
        return (double)this.index / (double)this.size;
    }

    @Override
    public String getStatus() {
        Pack pack = this.lastPack;
        if (pack != null) {
            return "Loading " + pack.getDirectory().getName() + "...";
        }
        return "Enumerating packs...";
    }
}

