/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.dialog;

import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.creator.Creator;
import com.skcraft.launcher.swing.SwingHelper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class AboutDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(AboutDialog.class.getName());
    private String version;

    public AboutDialog(Window parent) {
        super(parent, "About", Dialog.ModalityType.DOCUMENT_MODAL);
        try {
            Properties properties = LauncherUtils.loadProperties(Creator.class, "creator.properties", "com.skcraft.creator.propertiesFile");
            this.version = properties.getProperty("version", "????");
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to get version", e);
            this.version = "????";
        }
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        JPanel container = new JPanel();
        container.setLayout(new MigLayout("insets dialog"));
        container.add((Component)new JLabel(SwingHelper.createIcon(Creator.class, "about_header.png")), "dock north");
        container.add((Component)new JLabel("<html>Version " + this.version), "wrap");
        container.add((Component)new JLabel("<html>Licensed under GNU Lesser General Public License, version 3."), "wrap, gapbottom unrel");
        container.add((Component)new JLabel("<html>Created by the SKCraft team. Visit our website!"), "wrap, gapbottom unrel");
        JButton okButton = new JButton("OK");
        JButton sourceCodeButton = new JButton("Source Code");
        JButton skCraftButton = new JButton("Website");
        container.add((Component)sourceCodeButton, "span, split 3, sizegroup bttn");
        container.add((Component)skCraftButton, "sizegroup bttn");
        container.add((Component)okButton, "tag ok, sizegroup bttn");
        this.add((Component)container, "Center");
        this.getRootPane().setDefaultButton(okButton);
        this.getRootPane().registerKeyboardAction(e -> okButton.doClick(), KeyStroke.getKeyStroke(27, 0), 2);
        okButton.addActionListener(e -> this.dispose());
        sourceCodeButton.addActionListener(e -> SwingHelper.openURL("https://github.com/SKCraft/Launcher", (Component)this));
        skCraftButton.addActionListener(e -> SwingHelper.openURL("http://www.skcraft.com", (Component)this));
    }

    public static void showAboutDialog(Window parent) {
        AboutDialog dialog = new AboutDialog(parent);
        dialog.setVisible(true);
    }
}

