/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.dialog;

import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.TableSearchable;
import com.skcraft.launcher.creator.Creator;
import com.skcraft.launcher.creator.model.swing.ListingType;
import com.skcraft.launcher.creator.model.swing.ListingTypeComboBoxModel;
import com.skcraft.launcher.swing.DefaultTable;
import com.skcraft.launcher.swing.DirectoryField;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.swing.TableColumnAdjuster;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class GenerateListingDialog
extends JDialog {
    private final DirectoryField destDirField = new DirectoryField();
    private final JComboBox<ListingType> listingTypeCombo = new JComboBox<ListingType>(new ListingTypeComboBoxModel());
    private final JTable manifestsTable = new DefaultTable();
    private final JLabel gameKeyWarning = new JLabel("Selected listing type won't support adding modpacks using 'game keys'.", SwingHelper.createIcon(Creator.class, "warning_icon.png"), 2);
    private final JButton editManifestButton = new JButton("Modify...");
    private final JButton generateButton = new JButton("Generate");
    private final JButton cancelButton = new JButton("Cancel");
    private final TableColumnAdjuster manifestsTableAdjuster = new TableColumnAdjuster(this.manifestsTable);

    public GenerateListingDialog(Window parent) {
        super(parent, "Generate Package Listing", Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.manifestsTableAdjuster.adjustColumns();
        this.manifestsTableAdjuster.setDynamicAdjustment(true);
        this.manifestsTable.setAutoResizeMode(3);
        this.manifestsTable.setAutoCreateRowSorter(true);
        JPanel container = new JPanel();
        container.setLayout(new MigLayout("insets dialog, fill", "[grow 0][grow 100]"));
        container.add(new JLabel("Output Directory:"));
        container.add((Component)this.destDirField, "span");
        container.add(new JLabel("Package Listing Type:"));
        container.add(this.listingTypeCombo, "span");
        container.add((Component)this.gameKeyWarning, "span, skip 1, hidemode 3");
        container.add((Component)new JLabel("Modpacks to Include:"), "span, gaptop unrel");
        container.add((Component)SwingHelper.wrapScrollPane(this.manifestsTable), "grow, pushy, span, w 500:650, h 170");
        container.add((Component)this.editManifestButton, "gapbottom unrel, span, split 2");
        container.add((Component)new JLabel("<html>Previously-selected modpacks and those in the _upload directory are the available options."), "gapbottom unrel");
        container.add((Component)this.generateButton, "tag ok, span, split 2, sizegroup bttn");
        container.add((Component)this.cancelButton, "tag cancel, sizegroup bttn");
        this.add((Component)container, "Center");
        this.getRootPane().setDefaultButton(this.generateButton);
        this.getRootPane().registerKeyboardAction(e -> this.cancelButton.doClick(), KeyStroke.getKeyStroke(27, 0), 2);
        TableSearchable tableSearchable = SearchableUtils.installSearchable(this.manifestsTable);
        tableSearchable.setMainIndex(-1);
    }

    public DirectoryField getDestDirField() {
        return this.destDirField;
    }

    public JComboBox<ListingType> getListingTypeCombo() {
        return this.listingTypeCombo;
    }

    public JTable getManifestsTable() {
        return this.manifestsTable;
    }

    public JLabel getGameKeyWarning() {
        return this.gameKeyWarning;
    }

    public JButton getEditManifestButton() {
        return this.editManifestButton;
    }

    public JButton getGenerateButton() {
        return this.generateButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public TableColumnAdjuster getManifestsTableAdjuster() {
        return this.manifestsTableAdjuster;
    }
}

