/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.dialog;

import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.TableSearchable;
import com.skcraft.launcher.creator.Creator;
import com.skcraft.launcher.swing.DefaultTable;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.swing.TableColumnAdjuster;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class PackManagerFrame
extends JFrame {
    private final JButton newPackButton = new JButton("New Pack", SwingHelper.createIcon(Creator.class, "new.png"));
    private final JButton importButton = new JButton("Add Existing", SwingHelper.createIcon(Creator.class, "import.png"));
    private final JButton editConfigButton = new JButton("Modify", SwingHelper.createIcon(Creator.class, "edit.png"));
    private final JButton openFolderButton = new JButton("Open", SwingHelper.createIcon(Creator.class, "open_folder.png"));
    private final JButton checkProblemsButton = new JButton("Check", SwingHelper.createIcon(Creator.class, "check.png"));
    private final JButton testButton = new JButton("Test", SwingHelper.createIcon(Creator.class, "test.png"));
    private final JButton buildButton = new JButton("Build", SwingHelper.createIcon(Creator.class, "build.png"));
    private final JMenuItem newPackMenuItem = new JMenuItem("New Pack...");
    private final JMenuItem newPackAtLocationMenuItem = new JMenuItem("New Pack at Location...");
    private final JMenuItem importPackMenuItem = new JMenuItem("Add Existing Pack...");
    private final JMenuItem changePackLocationMenuItem = new JMenuItem("Change Pack Location...");
    private final JMenuItem refreshMenuItem = new JMenuItem("Reload Workspace");
    private final JMenuItem removePackItem = new JMenuItem("Remove Pack...");
    private final JMenuItem deletePackItem = new JMenuItem("Delete Pack Forever...");
    private final JMenuItem quitMenuItem = new JMenuItem("Exit");
    private final JMenuItem editConfigMenuItem = new JMenuItem("Edit modpack.json...");
    private final JMenuItem openFolderMenuItem = new JMenuItem("Open Directory");
    private final JMenuItem checkProblemsMenuItem = new JMenuItem("Scan for Problems...");
    private final JMenuItem testMenuItem = new JMenuItem("Test");
    private final JMenuItem testOnlineMenuItem = new JMenuItem("Test Online");
    private final JMenuItem optionsMenuItem = new JMenuItem("Test Launcher Options...");
    private final JMenuItem instanceOptionsMenuItem = new JMenuItem("Test Instance Options...");
    private final JMenuItem clearInstanceMenuItem = new JMenuItem("Delete Test Launcher Instances");
    private final JMenuItem clearWebRootMenuItem = new JMenuItem("Empty Test Web Server");
    private final JMenuItem buildMenuItem = new JMenuItem("Build Pack...");
    private final JMenuItem deployServerMenuItem = new JMenuItem("Deploy Server...");
    private final JMenuItem generatePackagesMenuItem = new JMenuItem("Generate packages.json...");
    private final JMenuItem openOutputFolderMenuItem = new JMenuItem("Open Upload Folder");
    private final JMenuItem versionCheckMenuItem = new JMenuItem("Check for Mod Updates");
    private final JMenuItem openWorkspaceFolderMenuItem = new JMenuItem("Open Workspace Folder");
    private final JMenuItem openLauncherFolderMenuItem = new JMenuItem("Open Test Launcher Folder");
    private final JMenuItem openWebRootMenuItem = new JMenuItem("Open Test Web Server Folder");
    private final JMenuItem openConsoleMenuItem = new JMenuItem("Open Console");
    private final JMenuItem docsMenuItem = new JMenuItem("Documentation");
    private final JMenuItem aboutMenuItem = new JMenuItem("About");
    private final JTable packTable = new DefaultTable();

    public PackManagerFrame() {
        super("Modpack Creator");
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.initMenu();
        this.pack();
        this.setLocationRelativeTo(null);
        SwingHelper.setFrameIcon(this, Creator.class, "icon.png");
    }

    private void initComponents() {
        TableColumnAdjuster adjuster = new TableColumnAdjuster(this.packTable);
        adjuster.adjustColumns();
        adjuster.setDynamicAdjustment(true);
        this.packTable.setAutoResizeMode(3);
        this.packTable.setAutoCreateRowSorter(true);
        JPanel container = new JPanel();
        container.setLayout(new MigLayout("fill, wrap 1"));
        container.add((Component)this.createToolbar(), "dock north");
        container.add((Component)SwingHelper.wrapScrollPane(this.packTable), "grow, span, w null:800:null");
        TableSearchable tableSearchable = SearchableUtils.installSearchable(this.packTable);
        tableSearchable.setMainIndex(-1);
        this.add((Component)container, "Center");
    }

    private JToolBar createToolbar() {
        JToolBar toolBar = new JToolBar("Toolbar");
        toolBar.setFloatable(false);
        toolBar.add(this.newPackButton);
        toolBar.add(this.importButton);
        toolBar.addSeparator();
        toolBar.add(this.editConfigButton);
        toolBar.add(this.openFolderButton);
        toolBar.add(this.checkProblemsButton);
        toolBar.addSeparator();
        toolBar.add(this.testButton);
        toolBar.add(this.buildButton);
        return toolBar;
    }

    private void initMenu() {
        int ctrlKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.newPackMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, ctrlKeyMask));
        this.newPackAtLocationMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, ctrlKeyMask | 1));
        this.editConfigMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, ctrlKeyMask));
        this.openFolderMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, ctrlKeyMask | 1));
        this.testMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.testOnlineMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.buildMenuItem.setAccelerator(KeyStroke.getKeyStroke(121, 1));
        this.deployServerMenuItem.setAccelerator(KeyStroke.getKeyStroke(120, 1));
        this.docsMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorder(BorderFactory.createEmptyBorder());
        Insets menuInset = new Insets(2, 2, 2, 2);
        JMenu menu = new JMenu("File");
        menu.setMargin(menuInset);
        menu.setMnemonic('f');
        menuBar.add(menu);
        menu.add(this.newPackMenuItem);
        menu.add(this.newPackAtLocationMenuItem);
        menu.add(this.importPackMenuItem);
        menu.addSeparator();
        menu.add(this.changePackLocationMenuItem);
        menu.add(this.removePackItem);
        menu.add(this.deletePackItem);
        menu.addSeparator();
        menu.add(this.refreshMenuItem);
        menu.addSeparator();
        menu.add(this.quitMenuItem);
        menu = new JMenu("Edit");
        menu.setMargin(menuInset);
        menu.setMnemonic('e');
        menuBar.add(menu);
        menu.add(this.editConfigMenuItem);
        menu.add(this.openFolderMenuItem);
        menu.addSeparator();
        menu.add(this.checkProblemsMenuItem);
        menu = new JMenu("Test");
        menu.setMargin(menuInset);
        menu.setMnemonic('t');
        menuBar.add(menu);
        menu.add(this.testMenuItem);
        menu.add(this.testOnlineMenuItem);
        menu.addSeparator();
        menu.add(this.optionsMenuItem);
        menu.add(this.instanceOptionsMenuItem);
        menu.addSeparator();
        menu.add(this.clearInstanceMenuItem);
        menu.add(this.clearWebRootMenuItem);
        menu = new JMenu("Build");
        menu.setMargin(menuInset);
        menu.setMnemonic('b');
        menuBar.add(menu);
        menu.add(this.buildMenuItem);
        menu.add(this.deployServerMenuItem);
        menu.addSeparator();
        menu.add(this.generatePackagesMenuItem);
        menu.addSeparator();
        menu.add(this.openOutputFolderMenuItem);
        menu = new JMenu("Tools");
        menu.setMargin(menuInset);
        menu.setMnemonic('t');
        menuBar.add(menu);
        menu.add(this.versionCheckMenuItem);
        menu.addSeparator();
        menu.add(this.openWorkspaceFolderMenuItem);
        menu.add(this.openLauncherFolderMenuItem);
        menu.add(this.openWebRootMenuItem);
        menu.addSeparator();
        menu.add(this.openConsoleMenuItem);
        menu = new JMenu("Help");
        menu.setMargin(menuInset);
        menu.setMnemonic('h');
        menuBar.add(menu);
        menu.add(this.docsMenuItem);
        menu.addSeparator();
        menu.add(this.aboutMenuItem);
        this.setJMenuBar(menuBar);
    }

    public JButton getNewPackButton() {
        return this.newPackButton;
    }

    public JButton getImportButton() {
        return this.importButton;
    }

    public JButton getEditConfigButton() {
        return this.editConfigButton;
    }

    public JButton getOpenFolderButton() {
        return this.openFolderButton;
    }

    public JButton getCheckProblemsButton() {
        return this.checkProblemsButton;
    }

    public JButton getTestButton() {
        return this.testButton;
    }

    public JButton getBuildButton() {
        return this.buildButton;
    }

    public JMenuItem getNewPackMenuItem() {
        return this.newPackMenuItem;
    }

    public JMenuItem getNewPackAtLocationMenuItem() {
        return this.newPackAtLocationMenuItem;
    }

    public JMenuItem getImportPackMenuItem() {
        return this.importPackMenuItem;
    }

    public JMenuItem getChangePackLocationMenuItem() {
        return this.changePackLocationMenuItem;
    }

    public JMenuItem getRefreshMenuItem() {
        return this.refreshMenuItem;
    }

    public JMenuItem getRemovePackItem() {
        return this.removePackItem;
    }

    public JMenuItem getDeletePackItem() {
        return this.deletePackItem;
    }

    public JMenuItem getQuitMenuItem() {
        return this.quitMenuItem;
    }

    public JMenuItem getEditConfigMenuItem() {
        return this.editConfigMenuItem;
    }

    public JMenuItem getOpenFolderMenuItem() {
        return this.openFolderMenuItem;
    }

    public JMenuItem getCheckProblemsMenuItem() {
        return this.checkProblemsMenuItem;
    }

    public JMenuItem getTestMenuItem() {
        return this.testMenuItem;
    }

    public JMenuItem getTestOnlineMenuItem() {
        return this.testOnlineMenuItem;
    }

    public JMenuItem getOptionsMenuItem() {
        return this.optionsMenuItem;
    }

    public JMenuItem getInstanceOptionsMenuItem() {
        return this.instanceOptionsMenuItem;
    }

    public JMenuItem getClearInstanceMenuItem() {
        return this.clearInstanceMenuItem;
    }

    public JMenuItem getClearWebRootMenuItem() {
        return this.clearWebRootMenuItem;
    }

    public JMenuItem getBuildMenuItem() {
        return this.buildMenuItem;
    }

    public JMenuItem getDeployServerMenuItem() {
        return this.deployServerMenuItem;
    }

    public JMenuItem getGeneratePackagesMenuItem() {
        return this.generatePackagesMenuItem;
    }

    public JMenuItem getOpenOutputFolderMenuItem() {
        return this.openOutputFolderMenuItem;
    }

    public JMenuItem getVersionCheckMenuItem() {
        return this.versionCheckMenuItem;
    }

    public JMenuItem getOpenWorkspaceFolderMenuItem() {
        return this.openWorkspaceFolderMenuItem;
    }

    public JMenuItem getOpenLauncherFolderMenuItem() {
        return this.openLauncherFolderMenuItem;
    }

    public JMenuItem getOpenWebRootMenuItem() {
        return this.openWebRootMenuItem;
    }

    public JMenuItem getOpenConsoleMenuItem() {
        return this.openConsoleMenuItem;
    }

    public JMenuItem getDocsMenuItem() {
        return this.docsMenuItem;
    }

    public JMenuItem getAboutMenuItem() {
        return this.aboutMenuItem;
    }

    public JTable getPackTable() {
        return this.packTable;
    }
}

