/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.dialog;

import com.skcraft.launcher.creator.dialog.ProblemTable;
import com.skcraft.launcher.creator.model.creator.Problem;
import com.skcraft.launcher.creator.model.swing.ProblemTableModel;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.swing.TextFieldPopupMenu;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class ProblemViewer
extends JDialog {
    private static final String DEFAULT_EXPLANATION = "Select a problem on the left to see the explanation here.";
    private final ProblemTable problemTable = new ProblemTable();
    private final ProblemTableModel problemTableModel;
    private final JTextArea explanationText = new JTextArea("Select a problem on the left to see the explanation here.");

    public ProblemViewer(Window parent, List<Problem> problems) {
        super(parent, "Potential Problems", Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.problemTableModel = new ProblemTableModel(problems);
        this.problemTable.setModel(this.problemTableModel);
    }

    private void initComponents() {
        this.explanationText.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
        this.explanationText.setFont(new JTextField().getFont());
        this.explanationText.setEditable(false);
        this.explanationText.setLineWrap(true);
        this.explanationText.setWrapStyleWord(true);
        JPanel container = new JPanel();
        container.setLayout(new MigLayout("fill, insets dialog"));
        JSplitPane splitPane = new JSplitPane(1, SwingHelper.wrapScrollPane(this.problemTable), SwingHelper.wrapScrollPane(this.explanationText));
        splitPane.setDividerLocation(180);
        SwingHelper.flattenJSplitPane(splitPane);
        container.add((Component)splitPane, "grow, w 220:500, h 240, wrap");
        JButton closeButton = new JButton("Close");
        container.add((Component)closeButton, "tag cancel, gaptop unrel");
        this.add((Component)container, "Center");
        this.getRootPane().setDefaultButton(closeButton);
        this.getRootPane().registerKeyboardAction(e -> closeButton.doClick(), KeyStroke.getKeyStroke(27, 0), 2);
        this.problemTable.getSelectionModel().addListSelectionListener(e -> {
            Problem selected = this.problemTableModel.getProblem(this.problemTable.getSelectedRow());
            if (selected != null) {
                SwingHelper.setTextAndResetCaret(this.explanationText, selected.getExplanation());
            }
        });
        closeButton.addActionListener(e -> this.dispose());
    }
}

