/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.model.creator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.net.URL;
import java.util.regex.Pattern;

public class ModFile {
    private File file;
    private String modId;
    private String name;
    private String gameVersion;
    private String version;
    private String latestVersion;
    private String latestDevVersion;
    private URL url;

    @JsonIgnore
    public String getCleanVersion() {
        String version = this.getVersion();
        return version != null ? version.replaceAll("^" + Pattern.quote(this.gameVersion) + "\\-", "").replaceAll("\\-" + Pattern.quote(this.gameVersion) + "$", "") : null;
    }

    public File getFile() {
        return this.file;
    }

    public String getModId() {
        return this.modId;
    }

    public String getName() {
        return this.name;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getLatestDevVersion() {
        return this.latestDevVersion;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setModId(String modId) {
        this.modId = modId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGameVersion(String gameVersion) {
        this.gameVersion = gameVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public void setLatestDevVersion(String latestDevVersion) {
        this.latestDevVersion = latestDevVersion;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModFile)) {
            return false;
        }
        ModFile other = (ModFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        String this$modId = this.getModId();
        String other$modId = other.getModId();
        if (this$modId == null ? other$modId != null : !this$modId.equals(other$modId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$gameVersion = this.getGameVersion();
        String other$gameVersion = other.getGameVersion();
        if (this$gameVersion == null ? other$gameVersion != null : !this$gameVersion.equals(other$gameVersion)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$latestVersion = this.getLatestVersion();
        String other$latestVersion = other.getLatestVersion();
        if (this$latestVersion == null ? other$latestVersion != null : !this$latestVersion.equals(other$latestVersion)) {
            return false;
        }
        String this$latestDevVersion = this.getLatestDevVersion();
        String other$latestDevVersion = other.getLatestDevVersion();
        if (this$latestDevVersion == null ? other$latestDevVersion != null : !this$latestDevVersion.equals(other$latestDevVersion)) {
            return false;
        }
        URL this$url = this.getUrl();
        URL other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !((Object)this$url).equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        String $modId = this.getModId();
        result = result * 59 + ($modId == null ? 43 : $modId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $gameVersion = this.getGameVersion();
        result = result * 59 + ($gameVersion == null ? 43 : $gameVersion.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $latestVersion = this.getLatestVersion();
        result = result * 59 + ($latestVersion == null ? 43 : $latestVersion.hashCode());
        String $latestDevVersion = this.getLatestDevVersion();
        result = result * 59 + ($latestDevVersion == null ? 43 : $latestDevVersion.hashCode());
        URL $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        return result;
    }

    public String toString() {
        return "ModFile(file=" + this.getFile() + ", modId=" + this.getModId() + ", name=" + this.getName() + ", gameVersion=" + this.getGameVersion() + ", version=" + this.getVersion() + ", latestVersion=" + this.getLatestVersion() + ", latestDevVersion=" + this.getLatestDevVersion() + ", url=" + this.getUrl() + ")";
    }
}

