/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.model.swing;

import com.skcraft.launcher.builder.FeaturePattern;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class FeaturePatternTableModel
extends AbstractTableModel {
    private final List<FeaturePattern> features;

    public FeaturePatternTableModel(List<FeaturePattern> features) {
        this.features = features;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Feature";
            }
            case 1: {
                return "Recommendation";
            }
            case 2: {
                return "Default?";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.features.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.features.get(rowIndex).getFeature().getName();
            }
            case 1: {
                return this.features.get(rowIndex).getFeature().getRecommendation();
            }
            case 2: {
                return this.features.get(rowIndex).getFeature().isSelected() ? "Yes" : "";
            }
        }
        return null;
    }

    public FeaturePattern getFeature(int index) {
        return this.features.get(index);
    }

    public void addFeature(FeaturePattern pattern) {
        this.features.add(pattern);
        this.fireTableDataChanged();
    }

    public void removeFeature(int index) {
        this.features.remove(index);
        this.fireTableDataChanged();
    }
}

