/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.model.swing;

import com.google.common.base.Preconditions;
import com.skcraft.launcher.creator.Creator;
import com.skcraft.launcher.creator.model.creator.ModFile;
import com.skcraft.launcher.swing.SwingHelper;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class ModFileTableModel
extends AbstractTableModel {
    private static final Icon WWW_ICON = SwingHelper.createIcon(Creator.class, "www_icon.png");
    private final List<ModFile> mods;

    public ModFileTableModel(List<ModFile> mods) {
        Preconditions.checkNotNull(mods, "mods");
        this.mods = mods;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "Mod";
            }
            case 2: {
                return "Version";
            }
            case 3: {
                return "Latest Release";
            }
            case 4: {
                return "Latest Dev";
            }
            case 5: {
                return "Mod ID";
            }
            case 6: {
                return "Filename";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Icon.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.mods.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ModFile mod = this.mods.get(rowIndex);
        if (mod == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return mod.getUrl() != null ? WWW_ICON : null;
            }
            case 1: {
                return mod.getName() != null ? mod.getName() : mod.getFile().getName();
            }
            case 2: {
                return mod.getCleanVersion();
            }
            case 3: {
                return mod.getLatestVersion();
            }
            case 4: {
                return mod.getLatestDevVersion();
            }
            case 5: {
                return mod.getModId();
            }
            case 6: {
                return mod.getFile().getName();
            }
        }
        return null;
    }

    public ModFile getMod(int index) {
        return this.mods.get(index);
    }
}

