/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.model.swing;

import com.skcraft.launcher.builder.BuilderConfig;
import com.skcraft.launcher.creator.Creator;
import com.skcraft.launcher.creator.model.creator.Pack;
import com.skcraft.launcher.swing.SwingHelper;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class PackTableModel
extends AbstractTableModel {
    private final Icon instanceIcon;
    private final Icon warningIcon;
    private final List<Pack> packs;

    public PackTableModel(List<Pack> packs) {
        this.packs = packs;
        this.instanceIcon = SwingHelper.createIcon(Creator.class, "pack_icon.png");
        this.warningIcon = SwingHelper.createIcon(Creator.class, "warning_icon.png");
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Title";
            }
            case 3: {
                return "Game Version";
            }
            case 4: {
                return "Location";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Icon.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.packs.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Pack pack = this.packs.get(rowIndex);
        BuilderConfig config = pack.getCachedConfig();
        switch (columnIndex) {
            case 0: {
                return config != null ? this.instanceIcon : this.warningIcon;
            }
            case 1: {
                return config != null ? config.getName() : "<Moved or Deleted>";
            }
            case 2: {
                return config != null ? config.getTitle() : "?";
            }
            case 3: {
                return config != null ? config.getGameVersion() : "?";
            }
            case 4: {
                return pack.getLocation();
            }
        }
        return null;
    }
}

