/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.creator.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ModInfoReader {
    private static final Logger log = Logger.getLogger(ModInfoReader.class.getName());
    private static final String FORGE_INFO_FILENAME = "mcmod.info";
    private static final String LITELOADER_INFO_FILENAME = "litemod.json";
    private final ObjectMapper mapper = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<? extends ModInfo> detectMods(File file) {
        List list;
        Closer closer = Closer.create();
        try {
            ZipEntry entry;
            FileInputStream fis = closer.register(new FileInputStream(file));
            BufferedInputStream bis = closer.register(new BufferedInputStream(fis));
            ZipInputStream zis = closer.register(new ZipInputStream(bis));
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getName().equalsIgnoreCase(FORGE_INFO_FILENAME)) {
                    List<ForgeModInfo> mods;
                    String content = CharStreams.toString(new InputStreamReader((InputStream)zis, Charsets.UTF_8));
                    try {
                        mods = this.mapper.readValue(content, ForgeModManifest.class).getMods();
                    }
                    catch (JsonParseException | JsonMappingException e) {
                        mods = this.mapper.readValue(content, new TypeReference<List<ForgeModInfo>>(){});
                    }
                    if (mods != null) {
                        List list2 = Collections.unmodifiableList(mods.stream().filter(info -> !info.getModId().equals("examplemod")).collect(Collectors.toList()));
                        return list2;
                    }
                    List list3 = Collections.emptyList();
                    return list3;
                }
                if (!entry.getName().equalsIgnoreCase(LITELOADER_INFO_FILENAME)) continue;
                String content = CharStreams.toString(new InputStreamReader((InputStream)zis, Charsets.UTF_8));
                ImmutableCollection immutableCollection = ((ImmutableList.Builder)new ImmutableList.Builder().add(this.mapper.readValue(content, LiteLoaderModInfo.class))).build();
                return immutableCollection;
            }
            List list4 = Collections.emptyList();
            return list4;
        }
        catch (JsonMappingException e) {
            log.log(Level.WARNING, "Unknown format mcmod.info file in " + file.getAbsolutePath(), e);
            list = Collections.emptyList();
            return list;
        }
        catch (JsonParseException e) {
            log.log(Level.WARNING, "Corrupt mcmod.info file in " + file.getAbsolutePath(), e);
            list = Collections.emptyList();
            return list;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (IOException e2) {
                log.log(Level.WARNING, "Failed to read " + file.getAbsolutePath(), e2);
                list = Collections.emptyList();
                return list;
            }
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException iOException) {}
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class LiteLoaderModInfo
    implements ModInfo {
        private String name;
        private String version;
        @JsonProperty(value="mcversion")
        private String gameVersion;
        private String revision;
        private String author;
        private String description;

        @Override
        @JsonIgnore
        public String getModId() {
            return null;
        }

        @Override
        public String getUrl() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getGameVersion() {
            return this.gameVersion;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getAuthor() {
            return this.author;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        @JsonProperty(value="mcversion")
        public void setGameVersion(String gameVersion) {
            this.gameVersion = gameVersion;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LiteLoaderModInfo)) {
                return false;
            }
            LiteLoaderModInfo other = (LiteLoaderModInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$gameVersion = this.getGameVersion();
            String other$gameVersion = other.getGameVersion();
            if (this$gameVersion == null ? other$gameVersion != null : !this$gameVersion.equals(other$gameVersion)) {
                return false;
            }
            String this$revision = this.getRevision();
            String other$revision = other.getRevision();
            if (this$revision == null ? other$revision != null : !this$revision.equals(other$revision)) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LiteLoaderModInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $gameVersion = this.getGameVersion();
            result = result * 59 + ($gameVersion == null ? 43 : $gameVersion.hashCode());
            String $revision = this.getRevision();
            result = result * 59 + ($revision == null ? 43 : $revision.hashCode());
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public String toString() {
            return "ModInfoReader.LiteLoaderModInfo(name=" + this.getName() + ", version=" + this.getVersion() + ", gameVersion=" + this.getGameVersion() + ", revision=" + this.getRevision() + ", author=" + this.getAuthor() + ", description=" + this.getDescription() + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ForgeModManifest {
        @JsonProperty(value="modListVersion")
        private int version;
        @JsonProperty(value="modList")
        private List<ForgeModInfo> mods;

        public int getVersion() {
            return this.version;
        }

        public List<ForgeModInfo> getMods() {
            return this.mods;
        }

        @JsonProperty(value="modListVersion")
        public void setVersion(int version) {
            this.version = version;
        }

        @JsonProperty(value="modList")
        public void setMods(List<ForgeModInfo> mods) {
            this.mods = mods;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForgeModManifest)) {
                return false;
            }
            ForgeModManifest other = (ForgeModManifest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            List<ForgeModInfo> this$mods = this.getMods();
            List<ForgeModInfo> other$mods = other.getMods();
            return !(this$mods == null ? other$mods != null : !((Object)this$mods).equals(other$mods));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForgeModManifest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVersion();
            List<ForgeModInfo> $mods = this.getMods();
            result = result * 59 + ($mods == null ? 43 : ((Object)$mods).hashCode());
            return result;
        }

        public String toString() {
            return "ModInfoReader.ForgeModManifest(version=" + this.getVersion() + ", mods=" + this.getMods() + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ForgeModInfo
    implements ModInfo {
        @JsonProperty(value="modid")
        private String modId;
        private String name;
        private String description;
        private String version;
        @JsonProperty(value="mcversion")
        private String gameVersion;
        private String url;
        private String updateUrl;
        private List<String> authorList;
        private String credits;
        private List<String> dependencies;

        @Override
        public String getModId() {
            return this.modId;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getGameVersion() {
            return this.gameVersion;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        public String getUpdateUrl() {
            return this.updateUrl;
        }

        public List<String> getAuthorList() {
            return this.authorList;
        }

        public String getCredits() {
            return this.credits;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        @JsonProperty(value="modid")
        public void setModId(String modId) {
            this.modId = modId;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        @JsonProperty(value="mcversion")
        public void setGameVersion(String gameVersion) {
            this.gameVersion = gameVersion;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setUpdateUrl(String updateUrl) {
            this.updateUrl = updateUrl;
        }

        public void setAuthorList(List<String> authorList) {
            this.authorList = authorList;
        }

        public void setCredits(String credits) {
            this.credits = credits;
        }

        public void setDependencies(List<String> dependencies) {
            this.dependencies = dependencies;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForgeModInfo)) {
                return false;
            }
            ForgeModInfo other = (ForgeModInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$modId = this.getModId();
            String other$modId = other.getModId();
            if (this$modId == null ? other$modId != null : !this$modId.equals(other$modId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$gameVersion = this.getGameVersion();
            String other$gameVersion = other.getGameVersion();
            if (this$gameVersion == null ? other$gameVersion != null : !this$gameVersion.equals(other$gameVersion)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$updateUrl = this.getUpdateUrl();
            String other$updateUrl = other.getUpdateUrl();
            if (this$updateUrl == null ? other$updateUrl != null : !this$updateUrl.equals(other$updateUrl)) {
                return false;
            }
            List<String> this$authorList = this.getAuthorList();
            List<String> other$authorList = other.getAuthorList();
            if (this$authorList == null ? other$authorList != null : !((Object)this$authorList).equals(other$authorList)) {
                return false;
            }
            String this$credits = this.getCredits();
            String other$credits = other.getCredits();
            if (this$credits == null ? other$credits != null : !this$credits.equals(other$credits)) {
                return false;
            }
            List<String> this$dependencies = this.getDependencies();
            List<String> other$dependencies = other.getDependencies();
            return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForgeModInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $modId = this.getModId();
            result = result * 59 + ($modId == null ? 43 : $modId.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $gameVersion = this.getGameVersion();
            result = result * 59 + ($gameVersion == null ? 43 : $gameVersion.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $updateUrl = this.getUpdateUrl();
            result = result * 59 + ($updateUrl == null ? 43 : $updateUrl.hashCode());
            List<String> $authorList = this.getAuthorList();
            result = result * 59 + ($authorList == null ? 43 : ((Object)$authorList).hashCode());
            String $credits = this.getCredits();
            result = result * 59 + ($credits == null ? 43 : $credits.hashCode());
            List<String> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            return result;
        }

        public String toString() {
            return "ModInfoReader.ForgeModInfo(modId=" + this.getModId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", gameVersion=" + this.getGameVersion() + ", url=" + this.getUrl() + ", updateUrl=" + this.getUpdateUrl() + ", authorList=" + this.getAuthorList() + ", credits=" + this.getCredits() + ", dependencies=" + this.getDependencies() + ")";
        }
    }

    public static interface ModInfo {
        public String getModId();

        public String getName();

        public String getDescription();

        public String getVersion();

        public String getGameVersion();

        public String getUrl();
    }
}

