/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.niofs.pathfs;

import cpw.mods.niofs.pathfs.PathFileSystem;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PathPath
implements Path {
    private final PathFileSystem fileSystem;
    private final String[] pathParts;
    static final String ROOT = "/";

    PathPath(PathFileSystem fileSystem, boolean knownCorrectSplit, String ... pathParts) {
        this.fileSystem = fileSystem;
        if (pathParts.length == 0) {
            this.pathParts = new String[0];
        } else if (knownCorrectSplit) {
            this.pathParts = pathParts;
        } else {
            String longstring = String.join((CharSequence)fileSystem.getSeparator(), pathParts);
            this.pathParts = this.getPathParts(longstring);
        }
    }

    protected PathPath(PathFileSystem fileSystem, Path innerPath) {
        this.fileSystem = fileSystem;
        this.pathParts = innerPath.toString().replace("\\", ROOT).split(ROOT);
    }

    private String[] getPathParts(String longstring) {
        String[] localParts;
        if (longstring.equals(this.getFileSystem().getSeparator())) {
            String[] stringArray = new String[1];
            v1 = stringArray;
            stringArray[0] = "";
        } else {
            v1 = localParts = longstring.replace("\\", this.getFileSystem().getSeparator()).split(this.getFileSystem().getSeparator());
        }
        if (this.getFileSystem().provider() != null) {
            return this.getFileSystem().provider().adaptPathParts(longstring, localParts);
        }
        return localParts;
    }

    @Override
    public PathFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.pathParts.length == 0 || this.pathParts[0].isEmpty();
    }

    @Override
    public Path getRoot() {
        return new PathPath(this.fileSystem, true, ROOT);
    }

    @Override
    public Path getFileName() {
        return this.pathParts.length > 0 ? new PathPath(this.getFileSystem(), true, this.pathParts[this.pathParts.length - 1]) : new PathPath(this.fileSystem, true, "");
    }

    @Override
    public Path getParent() {
        if (this.pathParts.length > 0) {
            return new PathPath(this.fileSystem, true, Arrays.copyOf(this.pathParts, this.pathParts.length - 1));
        }
        return null;
    }

    @Override
    public int getNameCount() {
        return this.pathParts.length;
    }

    @Override
    public Path getName(int index) {
        if (index < 0 || index > this.pathParts.length - 1) {
            throw new IllegalArgumentException();
        }
        return new PathPath(this.fileSystem, true, this.pathParts[index]);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > this.pathParts.length - 1 || endIndex < 0 || endIndex > this.pathParts.length || beginIndex > endIndex) {
            throw new IllegalArgumentException("Out of range " + beginIndex + " to " + endIndex + " for length " + this.pathParts.length);
        }
        return new PathPath(this.fileSystem, true, Arrays.copyOfRange(this.pathParts, beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        if (other.getFileSystem() != this.getFileSystem()) {
            return false;
        }
        Path path = other;
        if (path instanceof PathPath) {
            PathPath bp = (PathPath)path;
            return PathPath.checkArraysMatch(this.pathParts, bp.pathParts, false);
        }
        return false;
    }

    @Override
    public boolean endsWith(Path other) {
        if (other.getFileSystem() != this.getFileSystem()) {
            return false;
        }
        Path path = other;
        if (path instanceof PathPath) {
            PathPath bp = (PathPath)path;
            return PathPath.checkArraysMatch(this.pathParts, bp.pathParts, true);
        }
        return false;
    }

    private static boolean checkArraysMatch(String[] array1, String[] array2, boolean reverse) {
        int length = Math.min(array1.length, array2.length);
        IntBinaryOperator offset = reverse ? (l, i) -> l - i - 1 : (l, i) -> i;
        for (int i2 = 0; i2 < length; ++i2) {
            if (Objects.equals(array1[offset.applyAsInt(array1.length, i2)], array2[offset.applyAsInt(array2.length, i2)])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Path normalize() {
        ArrayDeque<String> normpath = new ArrayDeque<String>();
        String[] stringArray = this.pathParts;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String pathPart;
            switch (pathPart = stringArray[i]) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    normpath.removeLast();
                    continue block8;
                }
                default: {
                    normpath.addLast(pathPart);
                }
            }
        }
        return new PathPath(this.fileSystem, true, normpath.toArray(new String[0]));
    }

    @Override
    public Path resolve(Path other) {
        Path path = other;
        if (path instanceof PathPath) {
            PathPath path2 = (PathPath)path;
            if (path2.isAbsolute()) {
                return this.getFileSystem().provider().adaptResolvedPath(path2);
            }
            return this.getFileSystem().provider().adaptResolvedPath(new PathPath(this.fileSystem, false, this + this.fileSystem.getSeparator() + other));
        }
        return other;
    }

    @Override
    public Path relativize(Path other) {
        if (other.getFileSystem() != this.getFileSystem()) {
            throw new IllegalArgumentException("Wrong filesystem");
        }
        Path path = other;
        if (path instanceof PathPath) {
            int i;
            PathPath p = (PathPath)path;
            int poff = p.isAbsolute() ? 1 : 0;
            int meoff = this.isAbsolute() ? 1 : 0;
            int length = Math.min(this.pathParts.length - meoff, p.pathParts.length - poff);
            for (i = 0; i < length && Objects.equals(this.pathParts[i + meoff], p.pathParts[i + poff]); ++i) {
            }
            int remaining = this.pathParts.length - i - meoff;
            if (remaining == 0 && i == p.pathParts.length) {
                return new PathPath(this.getFileSystem(), false, new String[0]);
            }
            if (remaining == 0) {
                return p.subpath(i + 1, p.getNameCount());
            }
            String updots = IntStream.range(0, remaining).mapToObj(idx -> "..").collect(Collectors.joining(this.getFileSystem().getSeparator()));
            if (i == p.pathParts.length) {
                return new PathPath(this.getFileSystem(), false, updots);
            }
            return new PathPath(this.getFileSystem(), false, updots + this.getFileSystem().getSeparator() + p.subpath(i, p.getNameCount()));
        }
        throw new IllegalArgumentException("Wrong filesystem");
    }

    @Override
    public URI toUri() {
        try {
            return this.fileSystem.provider().buildUriFor(this);
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.fileSystem.getRoot().resolve(this);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return null;
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Path other) {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof PathPath) {
            PathPath p = (PathPath)object;
            return p.getFileSystem() == this.getFileSystem() && Arrays.equals(this.pathParts, p.pathParts);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.fileSystem) + 31 * Arrays.hashCode(this.pathParts);
    }

    @Override
    public String toString() {
        return String.join((CharSequence)this.fileSystem.getSeparator(), this.pathParts).replace("//", ROOT);
    }
}

