/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionFileSystemProvider;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.CodeSigner;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.Nullable;

public final class VirtualJar
implements SecureJar {
    private static final UnionFileSystemProvider UFSP = (UnionFileSystemProvider)FileSystemProvider.installedProviders().stream().filter(fsp -> fsp.getScheme().equals("union")).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find UnionFileSystemProvider"));
    private final ModuleDescriptor moduleDescriptor;
    private final SecureJar.ModuleDataProvider moduleData = new VirtualJarModuleDataProvider();
    private final UnionFileSystem dummyFileSystem;
    private final Manifest manifest = new Manifest();

    public VirtualJar(String name, Path referencePath, String ... packages) {
        if (!Files.exists(referencePath, new LinkOption[0])) {
            throw new IllegalArgumentException("VirtualJar reference path " + String.valueOf(referencePath) + " must exist");
        }
        this.moduleDescriptor = ModuleDescriptor.newAutomaticModule(name).packages(Set.of(packages)).build();
        this.dummyFileSystem = UFSP.newFileSystem((path, basePath) -> false, referencePath);
    }

    @Override
    public SecureJar.ModuleDataProvider moduleDataProvider() {
        return this.moduleData;
    }

    @Override
    public Path getPrimaryPath() {
        return this.dummyFileSystem.getPrimaryPath();
    }

    @Override
    @Nullable
    public CodeSigner[] getManifestSigners() {
        return null;
    }

    @Override
    public SecureJar.Status verifyPath(Path path) {
        return SecureJar.Status.NONE;
    }

    @Override
    public SecureJar.Status getFileStatus(String name) {
        return SecureJar.Status.NONE;
    }

    @Override
    @Nullable
    public Attributes getTrustedManifestEntries(String name) {
        return null;
    }

    @Override
    public boolean hasSecurityData() {
        return false;
    }

    @Override
    public String name() {
        return this.moduleDescriptor.name();
    }

    @Override
    public Path getPath(String first, String ... rest) {
        return this.dummyFileSystem.getPath(first, rest);
    }

    @Override
    public Path getRootPath() {
        return this.dummyFileSystem.getRoot();
    }

    private class VirtualJarModuleDataProvider
    implements SecureJar.ModuleDataProvider {
        private VirtualJarModuleDataProvider() {
        }

        @Override
        public String name() {
            return VirtualJar.this.name();
        }

        @Override
        public ModuleDescriptor descriptor() {
            return VirtualJar.this.moduleDescriptor;
        }

        @Override
        @Nullable
        public URI uri() {
            return null;
        }

        @Override
        public Optional<URI> findFile(String name) {
            return Optional.empty();
        }

        @Override
        public Optional<InputStream> open(String name) {
            return Optional.empty();
        }

        @Override
        public Manifest getManifest() {
            return VirtualJar.this.manifest;
        }

        @Override
        @Nullable
        public CodeSigner[] verifyAndGetSigners(String cname, byte[] bytes) {
            return null;
        }
    }
}

