/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.JarContentsImpl;
import cpw.mods.jarhandling.impl.JarSigningData;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.util.LambdaExceptionUtils;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSigner;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.Nullable;

public class Jar
implements SecureJar {
    private final JarContentsImpl contents;
    private final Manifest manifest;
    private final JarSigningData signingData;
    private final UnionFileSystem filesystem;
    private final JarModuleDataProvider moduleDataProvider;
    private final JarMetadata metadata;

    public Jar(JarContentsImpl contents, JarMetadata metadata) {
        this.contents = contents;
        this.manifest = contents.getManifest();
        this.signingData = contents.signingData;
        this.filesystem = contents.filesystem;
        this.moduleDataProvider = new JarModuleDataProvider(this);
        this.metadata = metadata;
    }

    public URI getURI() {
        return this.filesystem.getRootDirectories().iterator().next().toUri();
    }

    public ModuleDescriptor computeDescriptor() {
        return this.metadata.descriptor();
    }

    @Override
    public SecureJar.ModuleDataProvider moduleDataProvider() {
        return this.moduleDataProvider;
    }

    @Override
    public Path getPrimaryPath() {
        return this.filesystem.getPrimaryPath();
    }

    public Optional<URI> findFile(String name) {
        return this.contents.findFile(name);
    }

    @Override
    @Nullable
    public CodeSigner[] getManifestSigners() {
        return this.signingData.getManifestSigners();
    }

    @Override
    public SecureJar.Status verifyPath(Path path) {
        if (path.getFileSystem() != this.filesystem) {
            throw new IllegalArgumentException("Wrong filesystem");
        }
        String pathname = path.toString();
        return this.signingData.verifyPath(this.manifest, path, pathname);
    }

    @Override
    public SecureJar.Status getFileStatus(String name) {
        return this.signingData.getFileStatus(name);
    }

    @Override
    @Nullable
    public Attributes getTrustedManifestEntries(String name) {
        return this.signingData.getTrustedManifestEntries(this.manifest, name);
    }

    @Override
    public boolean hasSecurityData() {
        return this.signingData.hasSecurityData();
    }

    @Override
    public String name() {
        return this.metadata.name();
    }

    @Override
    public Path getPath(String first, String ... rest) {
        return this.filesystem.getPath(first, rest);
    }

    @Override
    public Path getRootPath() {
        return this.filesystem.getPath("", new String[0]);
    }

    public String toString() {
        return "Jar[" + String.valueOf(this.getURI()) + "]";
    }

    private record JarModuleDataProvider(Jar jar) implements SecureJar.ModuleDataProvider
    {
        @Override
        public String name() {
            return this.jar.name();
        }

        @Override
        public ModuleDescriptor descriptor() {
            return this.jar.computeDescriptor();
        }

        @Override
        public URI uri() {
            return this.jar.getURI();
        }

        @Override
        public Optional<URI> findFile(String name) {
            return this.jar.findFile(name);
        }

        @Override
        public Optional<InputStream> open(String name) {
            return this.jar.findFile(name).map(Paths::get).map(LambdaExceptionUtils.rethrowFunction(x$0 -> Files.newInputStream(x$0, new OpenOption[0])));
        }

        @Override
        public Manifest getManifest() {
            return this.jar.manifest;
        }

        @Override
        @Nullable
        public CodeSigner[] verifyAndGetSigners(String cname, byte[] bytes) {
            return this.jar.signingData.verifyAndGetSigners(this.jar.manifest, cname, bytes);
        }
    }
}

