/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.VirtualJar;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.spongepowered.asm.launch.MixinTransformationServiceAbstract;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.include.com.google.common.collect.ImmutableList;

public class MixinTransformationService
extends MixinTransformationServiceAbstract {
    public List<ITransformationService.Resource> completeScan(IModuleLayerManager layerManager) {
        try {
            if (this.detectVirtualJar(layerManager)) {
                try {
                    return ImmutableList.of(this.createVirtualJar(layerManager));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                return ImmutableList.of(this.createShim(layerManager));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            return super.completeScan(layerManager);
        }
    }

    private boolean detectVirtualJar(IModuleLayerManager layerManager) {
        try {
            MixinService.getService().getClassProvider().findClass("cpw.mods.jarhandling.VirtualJar", false);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private ITransformationService.Resource createVirtualJar(IModuleLayerManager layerManager) throws URISyntaxException {
        Path codeSource = Path.of(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        VirtualJar jar = new VirtualJar("mixin_synthetic", codeSource, new String[]{"org.spongepowered.asm.synthetic", "org.spongepowered.asm.synthetic.args"});
        return new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, ImmutableList.of(jar));
    }

    private ITransformationService.Resource createShim(IModuleLayerManager layerManager) throws URISyntaxException {
        URL resource = this.getClass().getResource("/shims/mixin_synthetic.zip");
        Path path = Paths.get(resource.toURI());
        SecureJar jar = SecureJar.from((Path[])new Path[]{path});
        return new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, ImmutableList.of(jar));
    }
}

