/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.nio.layzip;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.jarjar.nio.pathfs.PathFileSystemProvider;
import net.minecraftforge.jarjar.nio.pathfs.PathPath;

public class LayeredZipFileSystemProvider
extends PathFileSystemProvider {
    public static final String SCHEME = "jij";
    public static final String INDICATOR = "!";
    public static final String SEPARATOR = "!/";
    public static final String URI_SPLIT_REGEX = "!/";

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        String lastSection;
        String[] sections = uri.getRawSchemeSpecificPart().split("!/");
        FileSystem workingSystem = FileSystems.getDefault();
        String keyPrefix = "";
        if (sections.length > 1) {
            for (int i = 0; i < sections.length - 1; ++i) {
                String section = sections[i];
                if (section.startsWith("//")) {
                    section = section.substring(2);
                }
                section = this.handleAbsolutePrefixOnWindows(workingSystem, section);
                Path path = workingSystem.getPath(section, new String[0]).toAbsolutePath();
                workingSystem = this.getOrCreateNewSystem(keyPrefix, path);
                keyPrefix = keyPrefix + path.toString().replace("\\", "/") + INDICATOR;
            }
        }
        if ((lastSection = sections[sections.length - 1]).startsWith("//")) {
            lastSection = lastSection.substring(2);
        }
        Path lastPath = workingSystem.getPath(lastSection, new String[0]).toAbsolutePath();
        return this.getOrCreateNewSystem(keyPrefix, lastPath);
    }

    private String handleAbsolutePrefixOnWindows(FileSystem workingSystem, String section) {
        if (workingSystem.getClass().getName().toLowerCase(Locale.ROOT).contains("windows") && section.startsWith("/")) {
            section = section.substring(1);
        }
        return section;
    }

    private FileSystem getOrCreateNewSystem(Path path) {
        return this.getOrCreateNewSystem("", path);
    }

    private FileSystem getOrCreateNewSystem(String keyPrefix, Path path) {
        ImmutableMap args = ImmutableMap.of((Object)"packagePath", (Object)path.toAbsolutePath());
        try {
            return super.newFileSystem(new URI(super.getScheme() + ":" + keyPrefix + path.toString().replace("\\", "/")), (Map<String, ?>)args);
        }
        catch (Exception e) {
            throw new UncheckedIOException("Failed to create intermediary FS.", new IOException("Failed to process data.", e));
        }
    }

    @Override
    public Path getPath(URI uri) {
        String[] sections = uri.getRawSchemeSpecificPart().split("~");
        FileSystem workingSystem = FileSystems.getDefault();
        if (sections.length > 1) {
            for (int i = 0; i < sections.length - 1; ++i) {
                String section = sections[i];
                Path path = workingSystem.getPath(section, new String[0]);
                workingSystem = this.getOrCreateNewSystem(path);
            }
        }
        String lastSection = sections[sections.length - 1];
        return workingSystem.getPath(lastSection, new String[0]);
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        String[] sections = uri.getRawSchemeSpecificPart().split("~");
        FileSystem workingSystem = FileSystems.getDefault();
        if (sections.length > 1) {
            for (int i = 0; i < sections.length - 1; ++i) {
                String section = sections[i];
                Path path = workingSystem.getPath(section, new String[0]);
                workingSystem = this.getOrCreateNewSystem(path);
            }
        }
        String lastSection = sections[sections.length - 1];
        Path lastPath = workingSystem.getPath(lastSection, new String[0]);
        return this.getOrCreateNewSystem(lastPath);
    }

    @Override
    protected URI buildUriFor(PathPath path) throws URISyntaxException, IllegalArgumentException {
        String prefix = "";
        URI outerUri = path.getFileSystem().getTarget().toUri();
        prefix = outerUri.getRawSchemeSpecificPart() + "!/";
        return URI.create(String.format("%s:%s%s", SCHEME, prefix, path).replace(String.format("%s/", "!/"), "!/"));
    }

    @Override
    public Path adaptResolvedPath(PathPath path) {
        FileSystem workingSystem;
        if (!path.toString().contains("!/")) {
            return path;
        }
        Path workingPath = path.getFileSystem().getPath(path.toString().substring(0, path.toString().lastIndexOf("!/")) + "!/", new String[0]);
        try {
            workingSystem = FileSystems.newFileSystem(workingPath.toUri(), ImmutableMap.of());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to get sub file system for path!", e);
        }
        return workingSystem.getPath(path.endsWith("!/") ? "/" : path.toString().substring(path.toString().lastIndexOf("!/") + 2), new String[0]);
    }

    @Override
    public String[] adaptPathParts(String longstring, String[] pathParts) {
        if (!longstring.endsWith("!/")) {
            return pathParts;
        }
        pathParts[pathParts.length - 1] = pathParts[pathParts.length - 1] + "/";
        return pathParts;
    }
}

