/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import net.minecraftforge.eventbus.EventAccessTransformer;
import net.minecraftforge.eventbus.EventSubclassTransformer;
import net.minecraftforge.eventbus.LogMarkers;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public enum EventBusEngine {
    INSTANCE;

    private final EventSubclassTransformer eventTransformer;
    private final EventAccessTransformer accessTransformer;

    private EventBusEngine() {
        LogManager.getLogger().debug(LogMarkers.EVENTBUS, "Loading EventBus transformer");
        this.eventTransformer = new EventSubclassTransformer();
        this.accessTransformer = new EventAccessTransformer();
    }

    public boolean processClass(ClassNode classNode, Type classType) {
        boolean evtXform = this.eventTransformer.transform(classNode, classType).isPresent();
        boolean axXform = this.accessTransformer.transform(classNode, classType);
        return evtXform || axXform;
    }

    public boolean handlesClass(Type classType) {
        String name = classType.getClassName();
        return !name.equals("net.minecraftforge.eventbus.api.Event") && !name.startsWith("net.minecraft.") && name.indexOf(46) != -1;
    }
}

