/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.minecraftforge.eventbus.Cache;
import net.minecraftforge.eventbus.IEventListenerFactory;
import net.minecraftforge.eventbus.InternalUtils;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventListener;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class ClassLoaderFactory
implements IEventListenerFactory {
    private static final String HANDLER_DESC = Type.getInternalName(IEventListener.class);
    private static final String HANDLER_FUNC_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Event.class)});
    private static final ASMClassLoader LOADER = new ASMClassLoader();
    private static final Cache<Method, Class<?>> cache = InternalUtils.cache();

    @Override
    public IEventListener create(Method method, Object target) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Class<?> cls = this.createWrapper(method);
        if (Modifier.isStatic(method.getModifiers())) {
            return (IEventListener)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return (IEventListener)cls.getConstructor(Object.class).newInstance(target);
    }

    protected Class<?> createWrapper(Method callback) throws ClassNotFoundException {
        return cache.computeIfAbsent(callback, () -> {
            ClassNode node = new ClassNode();
            ClassLoaderFactory.transformNode(this.getUniqueName(callback), callback, node);
            return node;
        }, ClassLoaderFactory::defineClass);
    }

    private static final Class<?> defineClass(ClassNode node) {
        ClassWriter cw = new ClassWriter(0);
        node.accept((ClassVisitor)cw);
        return LOADER.define(node.name.replace('/', '.'), cw.toByteArray());
    }

    protected static void transformNode(String name, Method callback, ClassNode target) {
        boolean isStatic = Modifier.isStatic(callback.getModifiers());
        boolean isInterface = Modifier.isInterface(callback.getDeclaringClass().getModifiers());
        String desc = name.replace('.', '/');
        String instType = Type.getInternalName(callback.getDeclaringClass());
        String eventType = Type.getInternalName(callback.getParameterTypes()[0]);
        target.visit(60, 33, desc, null, "java/lang/Object", new String[]{HANDLER_DESC});
        target.visitSource(".dynamic", null);
        if (!isStatic) {
            target.visitField(1, "instance", "Ljava/lang/Object;", null, null).visitEnd();
        }
        MethodVisitor mv = target.visitMethod(1, "<init>", isStatic ? "()V" : "(Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        if (!isStatic) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, desc, "instance", "Ljava/lang/Object;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = target.visitMethod(1, "invoke", HANDLER_FUNC_DESC, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        if (!isStatic) {
            mv.visitFieldInsn(180, desc, "instance", "Ljava/lang/Object;");
            mv.visitTypeInsn(192, instType);
        }
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, eventType);
        int opcode = 182;
        if (isStatic) {
            opcode = 184;
        } else if (isInterface) {
            opcode = 185;
        }
        mv.visitMethodInsn(opcode, instType, callback.getName(), Type.getMethodDescriptor((Method)callback), isInterface);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        target.visitEnd();
    }

    private static class ASMClassLoader
    extends ClassLoader {
        private ASMClassLoader() {
            super(null);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return Class.forName(name, resolve, Thread.currentThread().getContextClassLoader());
        }

        Class<?> define(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }
}

