/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.jodah.typetools.TypeResolver;
import net.minecraftforge.eventbus.ASMEventHandler;
import net.minecraftforge.eventbus.BusBuilderImpl;
import net.minecraftforge.eventbus.ClassLoaderFactory;
import net.minecraftforge.eventbus.EventBusErrorMessage;
import net.minecraftforge.eventbus.IEventListenerFactory;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.LogMarkers;
import net.minecraftforge.eventbus.ModLauncherFactory;
import net.minecraftforge.eventbus.NamedEventListener;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventBusInvokeDispatcher;
import net.minecraftforge.eventbus.api.IEventExceptionHandler;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.eventbus.api.IGenericEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class EventBus
implements IEventExceptionHandler,
IEventBus {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean checkTypesOnDispatchProperty = Boolean.parseBoolean(System.getProperty("eventbus.checkTypesOnDispatch", "false"));
    private static final AtomicInteger maxID = new AtomicInteger(0);
    private final boolean trackPhases;
    private final ConcurrentHashMap<Object, List<IEventListener>> listeners = new ConcurrentHashMap();
    private final int busID = maxID.getAndIncrement();
    private final IEventExceptionHandler exceptionHandler;
    private volatile boolean shutdown = false;
    private final Class<?> baseType;
    private final boolean checkTypesOnDispatch;
    private final IEventListenerFactory factory;
    private static final Predicate<Event> checkCancelled = e -> !e.isCanceled();

    private EventBus() {
        ListenerList.resize(this.busID + 1);
        this.exceptionHandler = this;
        this.trackPhases = true;
        this.baseType = Event.class;
        this.checkTypesOnDispatch = checkTypesOnDispatchProperty;
        this.factory = new ClassLoaderFactory();
    }

    private EventBus(IEventExceptionHandler handler, boolean trackPhase, boolean startShutdown, Class<?> baseType, boolean checkTypesOnDispatch, IEventListenerFactory factory) {
        ListenerList.resize(this.busID + 1);
        this.exceptionHandler = handler == null ? this : handler;
        this.trackPhases = trackPhase;
        this.shutdown = startShutdown;
        this.baseType = baseType;
        this.checkTypesOnDispatch = checkTypesOnDispatch || checkTypesOnDispatchProperty;
        this.factory = factory;
    }

    public EventBus(BusBuilderImpl busBuilder) {
        this(busBuilder.exceptionHandler, busBuilder.trackPhases, busBuilder.startShutdown, busBuilder.markerType, busBuilder.checkTypesOnDispatch, busBuilder.modLauncher ? new ModLauncherFactory() : new ClassLoaderFactory());
    }

    private void registerClass(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(SubscribeEvent.class)) continue;
            this.registerListener(clazz, method, method);
        }
    }

    private void registerObject(Object obj) {
        Method[] methods = obj.getClass().getMethods();
        record Key(String name, Class<?>[] args) {
        }
        HashMap<Key, Method> unannotated = new HashMap<Key, Method>();
        for (Method method : methods) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (method.isAnnotationPresent(SubscribeEvent.class)) {
                this.registerListener(obj, method, method);
                continue;
            }
            if (method.getDeclaringClass() == Object.class) continue;
            unannotated.put(new Key(method.getName(), method.getParameterTypes()), method);
        }
        if (unannotated.isEmpty()) {
            return;
        }
        LinkedHashSet classes = new LinkedHashSet();
        Stack stack = new Stack();
        this.parentTypes(classes, stack, obj.getClass());
        while (!stack.isEmpty()) {
            Class<?> cls = stack.pop();
            for (Method method : cls.getDeclaredMethods()) {
                Method needed;
                if (Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(SubscribeEvent.class) || (needed = (Method)unannotated.remove(new Key(method.getName(), method.getParameterTypes()))) == null) continue;
                this.registerListener(obj, method, method);
            }
            if (unannotated.isEmpty()) continue;
            this.parentTypes(classes, stack, cls);
        }
    }

    private void parentTypes(Set<Class<?>> classes, Stack<Class<?>> stack, Class<?> cls) {
        for (Class<?> inf : cls.getInterfaces()) {
            if (!classes.add(inf)) continue;
            stack.push(inf);
        }
        Class<?> parent = cls.getSuperclass();
        if (parent != null && parent != Object.class && classes.add(parent)) {
            stack.push(parent);
        }
    }

    @Override
    public void register(Object target) {
        if (this.listeners.containsKey(target)) {
            return;
        }
        if (target.getClass() == Class.class) {
            this.registerClass((Class)target);
        } else {
            this.registerObject(target);
        }
    }

    private void registerListener(Object target, Method method, Method real) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation. It has " + parameterTypes.length + " arguments, but event handler methods require a single argument only.");
        }
        Class<?> eventType = parameterTypes[0];
        if (!Event.class.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but takes an argument that is not an Event subtype : " + eventType);
        }
        if (this.baseType != Event.class && !this.baseType.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but takes an argument that is not a subtype of the base type " + this.baseType + ": " + eventType);
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Failed to create ASMEventHandler for " + target.getClass().getName() + "." + method.getName() + Type.getMethodDescriptor((Method)method) + " it is not public and our transformer is disabled");
        }
        this.register(eventType, target, real);
    }

    private static <T extends Event> Predicate<T> passCancelled(boolean ignored) {
        return ignored ? null : checkCancelled;
    }

    private static <T extends GenericEvent<? extends F>, F> Predicate<T> passGenericFilter(Class<F> type, boolean ignored) {
        if (ignored) {
            return e -> e.getGenericType() == type;
        }
        return e -> e.getGenericType() == type && !e.isCanceled();
    }

    private static void checkNotGeneric(Consumer<? extends Event> consumer) {
        EventBus.checkNotGeneric(EventBus.getEventClass(consumer));
    }

    private static void checkNotGeneric(Class<? extends Event> eventType) {
        if (GenericEvent.class.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Cannot register a generic event listener with addListener, use addGenericListener");
        }
    }

    @Override
    public <T extends Event> void addListener(Consumer<T> consumer) {
        this.addListener(EventPriority.NORMAL, consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, Consumer<T> consumer) {
        this.addListener(priority, false, consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, boolean receiveCancelled, Consumer<T> consumer) {
        EventBus.checkNotGeneric(consumer);
        this.addListener(priority, EventBus.passCancelled(receiveCancelled), consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, boolean receiveCancelled, Class<T> eventType, Consumer<T> consumer) {
        EventBus.checkNotGeneric(eventType);
        this.addListener(priority, EventBus.passCancelled(receiveCancelled), eventType, consumer);
    }

    @Override
    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, Consumer<T> consumer) {
        this.addGenericListener(genericClassFilter, EventPriority.NORMAL, consumer);
    }

    @Override
    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, Consumer<T> consumer) {
        this.addGenericListener(genericClassFilter, priority, false, consumer);
    }

    @Override
    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, boolean receiveCancelled, Consumer<T> consumer) {
        this.addListener(priority, EventBus.passGenericFilter(genericClassFilter, receiveCancelled), consumer);
    }

    @Override
    public <T extends GenericEvent<? extends F>, F> void addGenericListener(Class<F> genericClassFilter, EventPriority priority, boolean receiveCancelled, Class<T> eventType, Consumer<T> consumer) {
        this.addListener(priority, EventBus.passGenericFilter(genericClassFilter, receiveCancelled), eventType, consumer);
    }

    private static <T extends Event> Class<T> getEventClass(Consumer<T> consumer) {
        Class eventClass = TypeResolver.resolveRawArgument(Consumer.class, consumer.getClass());
        if (eventClass == TypeResolver.Unknown.class) {
            LOGGER.error(LogMarkers.EVENTBUS, "Failed to resolve handler for \"{}\"", (Object)consumer.toString());
            throw new IllegalStateException("Failed to resolve consumer event type: " + consumer.toString());
        }
        return eventClass;
    }

    private <T extends Event> void addListener(EventPriority priority, Predicate<? super T> filter, Consumer<T> consumer) {
        Class<T> eventClass = EventBus.getEventClass(consumer);
        if (Objects.equals(eventClass, Event.class)) {
            LOGGER.warn(LogMarkers.EVENTBUS, "Attempting to add a Lambda listener with computed generic type of Event. Are you sure this is what you meant? NOTE : there are complex lambda forms where the generic type information is erased and cannot be recovered at runtime.");
        }
        this.addListener(priority, filter, eventClass, consumer);
    }

    private <T extends Event> void addListener(EventPriority priority, Predicate<? super T> filter, Class<T> eventClass, Consumer<T> consumer) {
        if (this.baseType != Event.class && !this.baseType.isAssignableFrom(eventClass)) {
            throw new IllegalArgumentException("Listener for event " + eventClass + " takes an argument that is not a subtype of the base type " + this.baseType);
        }
        this.addToListeners(consumer, eventClass, NamedEventListener.namedWrapper(e -> EventBus.doCastFilter(filter, eventClass, consumer, e), consumer.getClass()::getName), priority);
    }

    private static <T extends Event> void doCastFilter(Predicate<? super T> filter, Class<T> eventClass, Consumer<T> consumer, Event e) {
        Event cast = e;
        if (filter == null || filter.test(cast)) {
            consumer.accept(cast);
        }
    }

    private void register(Class<?> eventType, Object target, Method method) {
        try {
            ASMEventHandler asm = new ASMEventHandler(this.factory, target, method, IGenericEvent.class.isAssignableFrom(eventType));
            this.addToListeners(target, eventType, asm, asm.getPriority());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error(LogMarkers.EVENTBUS, "Error registering event handler: {} {}", eventType, (Object)method, (Object)e);
        }
    }

    private void addToListeners(Object target, Class<?> eventType, IEventListener listener, EventPriority priority) {
        ListenerList listenerList = EventListenerHelper.getListenerList(eventType);
        listenerList.register(this.busID, priority, listener);
        List others = this.listeners.computeIfAbsent(target, k -> Collections.synchronizedList(new ArrayList()));
        others.add(listener);
    }

    @Override
    public void unregister(Object object) {
        List<IEventListener> list = this.listeners.remove(object);
        if (list == null) {
            return;
        }
        for (IEventListener listener : list) {
            ListenerList.unregisterAll(this.busID, listener);
        }
    }

    @Override
    public boolean post(Event event) {
        return this.post(event, IEventListener::invoke);
    }

    @Override
    public boolean post(Event event, IEventBusInvokeDispatcher wrapper) {
        int index;
        if (this.shutdown) {
            return false;
        }
        if (this.checkTypesOnDispatch && !this.baseType.isInstance(event)) {
            throw new IllegalArgumentException("Cannot post event of type " + event.getClass().getSimpleName() + " to this event. Must match type: " + this.baseType.getSimpleName());
        }
        IEventListener[] listeners = event.getListenerList().getListeners(this.busID);
        try {
            for (index = 0; index < listeners.length; ++index) {
                if (!this.trackPhases && listeners[index].getClass() == EventPriority.class) continue;
                wrapper.invoke(listeners[index], event);
            }
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException(this, event, listeners, index, throwable);
            throw throwable;
        }
        return event.isCanceled();
    }

    @Override
    public void handleException(IEventBus bus, Event event, IEventListener[] listeners, int index, Throwable throwable) {
        LOGGER.error(LogMarkers.EVENTBUS, () -> new EventBusErrorMessage(event, index, listeners, throwable));
    }

    @Override
    public void shutdown() {
        LOGGER.fatal(LogMarkers.EVENTBUS, "EventBus {} shutting down - future events will not be posted.", (Object)this.busID, (Object)new Exception("stacktrace"));
        this.shutdown = true;
    }

    @Override
    public void start() {
        this.shutdown = false;
    }

    private void clearInternalData() {
        this.clearCache(EventListenerHelper.class, "listeners");
        this.clearCache(EventListenerHelper.class, "cancelable");
        this.clearCache(EventListenerHelper.class, "hasResult");
        this.clearCache(ModLauncherFactory.class, "PENDING");
        this.clearCache(ClassLoaderFactory.class, "cache");
    }

    private void clearCache(Class<?> cls, String name) {
        try {
            Field cfld = cls.getDeclaredField(name);
            cfld.setAccessible(true);
            Object cache = cfld.get(null);
            Field mfld = cache.getClass().getDeclaredField("map");
            mfld.setAccessible(true);
            Map map = (Map)mfld.get(cache);
            map.clear();
        }
        catch (Exception e) {
            EventBus.sneak(e);
        }
    }

    private static <E extends Throwable, R> R sneak(Throwable e) throws E {
        throw e;
    }
}

