/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ITransformerDiscoveryService;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;

public class ModDirTransformerDiscoverer
implements ITransformerDiscoveryService {
    private static final List<NamedPath> found = new ArrayList<NamedPath>();

    public List<NamedPath> candidates(Path gameDirectory) {
        ModDirTransformerDiscoverer.scan(gameDirectory);
        return List.copyOf(found);
    }

    public static List<Path> allExcluded() {
        return found.stream().map(np -> np.paths()[0]).toList();
    }

    private static void scan(Path gameDirectory) {
        Path modsDir = gameDirectory.resolve(FMLPaths.MODSDIR.relative()).toAbsolutePath().normalize();
        if (!Files.exists(modsDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> walk = Files.walk(modsDir, 1, new FileVisitOption[0]);){
            walk.forEach(ModDirTransformerDiscoverer::visitFile);
        }
        catch (IOException | IllegalStateException ioe) {
            LogManager.getLogger().error("Error during early discovery", (Throwable)ioe);
        }
    }

    private static void visitFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return;
        }
        if (!path.toString().endsWith(".jar")) {
            return;
        }
        if ((Long)LamdbaExceptionUtils.uncheck(() -> Files.size(path)) == 0L) {
            return;
        }
        try (ZipFile zf = new ZipFile(new File(path.toUri()));){
            if (zf.getEntry("META-INF/services/cpw.mods.modlauncher.api.ITransformationService") != null) {
                found.add(new NamedPath(zf.getName(), new Path[]{path}));
            } else if (zf.getEntry("META-INF/services/net.minecraftforge.forgespi.locating.IModLocator") != null) {
                found.add(new NamedPath(zf.getName(), new Path[]{path}));
            }
        }
        catch (IOException ioe) {
            LogManager.getLogger().error("Zip Error when loading jar file {}", (Object)path, (Object)ioe);
        }
    }
}

