/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.ServiceRunner;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.targets.ArgumentList;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
abstract class CommonDevLaunchHandler
extends CommonLaunchHandler {
    protected CommonDevLaunchHandler(CommonLaunchHandler.LaunchType type, String prefix) {
        super(type, prefix);
    }

    @Override
    public String getNaming() {
        return "mcp";
    }

    @Override
    public boolean isProduction() {
        return false;
    }

    @Override
    protected String[] preLaunch(String[] arguments, ModuleLayer layer) {
        super.preLaunch(arguments, layer);
        if (this.getDist().isDedicatedServer()) {
            return arguments;
        }
        if (this.isData()) {
            return arguments;
        }
        ArgumentList args = ArgumentList.from(arguments);
        String username = args.get("username");
        if (username != null) {
            Matcher m = Pattern.compile("#+").matcher(username);
            StringBuffer replaced = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(replaced, CommonDevLaunchHandler.getRandomNumbers(m.group().length()));
            }
            m.appendTail(replaced);
            args.put("username", replaced.toString());
        } else {
            args.putLazy("username", "Dev");
        }
        if (!args.hasValue("accessToken")) {
            args.put("accessToken", "0");
        }
        return args.getArguments();
    }

    protected List<Path> getLibraries(String[] classpath) {
        Path fmlcore = CommonDevLaunchHandler.findJarOnClasspath(classpath, "fmlcore");
        Path javafmllang = CommonDevLaunchHandler.findJarOnClasspath(classpath, "javafmllanguage");
        Path lowcodelang = CommonDevLaunchHandler.findJarOnClasspath(classpath, "lowcodelanguage");
        Path mclang = CommonDevLaunchHandler.findJarOnClasspath(classpath, "mclanguage");
        return List.of(fmlcore, javafmllang, lowcodelang, mclang);
    }

    protected BiPredicate<String, String> getMcFilter(Path extra, List<Path> minecraft) {
        String[] packages = CommonDevLaunchHandler.getPackages();
        String extraPath = extra.toString().replace('\\', '/');
        BiPredicate<String, String> mcFilter = (path, base) -> {
            if (base.equals(extraPath) || path.endsWith("/")) {
                return true;
            }
            for (String pkg : packages) {
                if (!path.startsWith(pkg)) continue;
                return false;
            }
            return true;
        };
        return mcFilter;
    }

    protected Path getForgeMod(List<Path> minecraft) {
        String[] packages = CommonDevLaunchHandler.getPackages();
        SecureJar modJar = SecureJar.from((path, base) -> {
            if (!path.endsWith(".class")) {
                return true;
            }
            for (String pkg : packages) {
                if (!path.startsWith(pkg)) continue;
                return true;
            }
            return false;
        }, (Path[])((Path[])minecraft.stream().distinct().toArray(Path[]::new)));
        return modJar.getRootPath();
    }

    private static String[] getPackages() {
        return new String[]{"net/minecraftforge/", "META-INF/services/", "META-INF/coremods.json", "META-INF/mods.toml"};
    }

    private static String getRandomNumbers(int length) {
        return Long.toString(System.nanoTime() % (long)((int)Math.pow(10.0, length)));
    }

    @Override
    protected ServiceRunner makeService(String[] arguments, ModuleLayer gameLayer) {
        return super.makeService(this.preLaunch(arguments, gameLayer), gameLayer);
    }

    protected static Map<String, List<Path>> getModClasses() {
        String[] entries;
        String modClasses = Optional.ofNullable(System.getenv("MOD_CLASSES")).orElse("");
        LOGGER.debug(LogMarkers.CORE, "Got mod coordinates {} from env", (Object)modClasses);
        HashMap<String, List<Path>> ret = new HashMap<String, List<Path>>();
        for (String entry : entries = modClasses.split(File.pathSeparator)) {
            String modid = "defaultmodid";
            String path = entry;
            int idx = entry.indexOf("%%");
            if (idx != -1) {
                modid = entry.substring(0, idx);
                path = entry.substring(idx + 2);
            }
            Path p = Paths.get(path, new String[0]);
            List lst = ret.computeIfAbsent(modid, k -> new ArrayList());
            if (lst.contains(p)) continue;
            lst.add(p);
        }
        LOGGER.debug(LogMarkers.CORE, "Found supplied mod coordinates:");
        ret.forEach((k, v) -> {
            if (v.size() == 1) {
                LOGGER.debug(LogMarkers.CORE, "\t{}: {}", k, v.get(0));
            } else {
                LOGGER.debug(LogMarkers.CORE, "\t{}:", k);
                v.forEach(e -> LOGGER.debug("\t\t{}", e));
            }
        });
        return ret;
    }

    protected static Path findJarOnClasspath(String[] classpath, String match) {
        String ret = null;
        for (String entry : classpath) {
            String name;
            int idx = entry.lastIndexOf(File.separatorChar);
            if (idx == -1 || !(name = entry.substring(idx + 1)).startsWith(match)) continue;
            ret = entry;
            break;
        }
        if (ret == null) {
            new IllegalStateException("Could not find " + match + " in classpath");
        }
        return Paths.get(ret, new String[0]);
    }
}

