/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.fml.loading.moddiscovery.ModJarMetadata;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.IModProvider;
import net.minecraftforge.forgespi.locating.ModFileLoadingException;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public abstract class AbstractModProvider
implements IModProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final String MODS_TOML = "META-INF/mods.toml";

    protected IModLocator.ModFileOrException createMod(Path path) {
        ModFile mod;
        ModJarMetadata mjm = new ModJarMetadata();
        SecureJar sj = SecureJar.from(jar -> jar.moduleDataProvider().findFile(MODS_TOML).isPresent() ? mjm : JarMetadata.from((SecureJar)jar, (Path[])new Path[]{path}), (Path[])new Path[]{path});
        String type = sj.moduleDataProvider().getManifest().getMainAttributes().getValue(ModFile.TYPE);
        if (type == null) {
            type = this.getDefaultJarModType();
        }
        if (sj.moduleDataProvider().findFile(MODS_TOML).isPresent()) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", new Object[]{MODS_TOML, type, path});
            mod = new ModFile(sj, this, ModFileParser::modsTomlParser);
        } else if (type != null) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", new Object[]{"META-INF/MANIFEST.MF", type, path});
            mod = new ModFile(sj, this, this::manifestParser, type);
        } else {
            return new IModLocator.ModFileOrException(null, new ModFileLoadingException("Invalid mod file found " + path));
        }
        mjm.setModFile(mod);
        return new IModLocator.ModFileOrException((IModFile)mod, null);
    }

    protected IModFileInfo manifestParser(IModFile mod) {
        Attributes mf = mod.getSecureJar().moduleDataProvider().getManifest().getMainAttributes();
        String license = mf.getValue("LICENSE");
        IConfigurable dummy = new IConfigurable(){

            public <T> Optional<T> getConfigElement(String ... key) {
                return Optional.empty();
            }

            public List<? extends IConfigurable> getConfigList(String ... key) {
                return Collections.emptyList();
            }
        };
        return new DefaultModFileInfo(mod, license == null ? "" : license, dummy);
    }

    public boolean isValid(IModFile modFile) {
        return true;
    }

    public void initArguments(Map<String, ?> arguments) {
    }

    protected String getDefaultJarModType() {
        return null;
    }

    public void scanFile(IModFile file, Consumer<Path> pathConsumer) {
        LOGGER.debug(LogMarkers.SCAN, "Scan started: {}", (Object)file);
        SecureJar jar = file.getSecureJar();
        Path root = jar.getRootPath();
        Consumer<Path> consumer = pathConsumer;
        Holder holder = new Holder();
        holder.value = SecureJar.Status.NONE;
        if (jar.hasSecurityData()) {
            consumer = path -> {
                pathConsumer.accept((Path)path);
                SecureJar.Status status = jar.verifyPath(path);
                if (status.ordinal() < ((SecureJar.Status)holder.value).ordinal()) {
                    holder.value = status;
                }
            };
        }
        try {
            Files.walk(root, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".class")).forEach(consumer);
            file.setSecurityStatus((SecureJar.Status)holder.value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.debug(LogMarkers.SCAN, "Scan finished: {}", (Object)file);
    }

    private record DefaultModFileInfo(IModFile mod, String license, IConfigurable configurable) implements IModFileInfo,
    IConfigurable
    {
        public <T> Optional<T> getConfigElement(String ... strings) {
            return Optional.empty();
        }

        public List<? extends IConfigurable> getConfigList(String ... strings) {
            return null;
        }

        public List<IModInfo> getMods() {
            return Collections.emptyList();
        }

        public List<IModFileInfo.LanguageSpec> requiredLanguageLoaders() {
            return Collections.emptyList();
        }

        public boolean showAsResourcePack() {
            return false;
        }

        public boolean showAsDataPack() {
            return false;
        }

        public Map<String, Object> getFileProperties() {
            return Collections.emptyMap();
        }

        public String getLicense() {
            return this.license;
        }

        public IModFile getFile() {
            return this.mod;
        }

        public IConfigurable getConfig() {
            return this.configurable;
        }

        public String moduleName() {
            return this.mod.getSecureJar().name();
        }

        public String versionString() {
            return null;
        }

        public List<String> usesServices() {
            return null;
        }

        @Override
        public String toString() {
            return "IModFileInfo(" + this.mod.getFilePath() + ")";
        }
    }

    private static class Holder<T> {
        T value;

        private Holder() {
        }
    }
}

