/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.UniqueModListBuilder;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModValidator;
import net.minecraftforge.fml.loading.moddiscovery.ModsFolderLocator;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IDependencyLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.ModFileLoadingException;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public class ModDiscoverer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ServiceLoader<IModLocator> modLocators;
    private final ServiceLoader<IDependencyLocator> dependencyLocators;
    private final List<IModLocator> modLocatorList;
    private final List<IDependencyLocator> dependencyLocatorList;

    public ModDiscoverer(Map<String, ?> arguments) {
        Launcher.INSTANCE.environment().computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.MODDIRECTORYFACTORY.get(), v -> ModsFolderLocator::new);
        Launcher.INSTANCE.environment().computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.PROGRESSMESSAGE.get(), v -> StartupNotificationManager.locatorConsumer().orElseGet(() -> s -> {}));
        IModuleLayerManager moduleLayerManager = (IModuleLayerManager)Launcher.INSTANCE.environment().findModuleLayerManager().orElseThrow();
        this.modLocators = ServiceLoader.load((ModuleLayer)moduleLayerManager.getLayer(IModuleLayerManager.Layer.SERVICE).orElseThrow(), IModLocator.class);
        this.dependencyLocators = ServiceLoader.load((ModuleLayer)moduleLayerManager.getLayer(IModuleLayerManager.Layer.SERVICE).orElseThrow(), IDependencyLocator.class);
        this.modLocatorList = ServiceLoaderUtils.streamServiceLoader(() -> this.modLocators, sce -> LOGGER.error("Failed to load mod locator list", (Throwable)sce)).collect(Collectors.toList());
        this.modLocatorList.forEach(l -> l.initArguments(arguments));
        this.dependencyLocatorList = ServiceLoaderUtils.streamServiceLoader(() -> this.dependencyLocators, sce -> LOGGER.error("Failed to load dependency locator list", (Throwable)sce)).collect(Collectors.toList());
        this.dependencyLocatorList.forEach(l -> l.initArguments(arguments));
        if (LOGGER.isDebugEnabled(LogMarkers.CORE)) {
            LOGGER.debug(LogMarkers.CORE, "Found Mod Locators : {}", (Object)this.modLocatorList.stream().map(modLocator -> "(%s:%s)".formatted(modLocator.name(), modLocator.getClass().getPackage().getImplementationVersion())).collect(Collectors.joining(",")));
        }
        if (LOGGER.isDebugEnabled(LogMarkers.CORE)) {
            LOGGER.debug(LogMarkers.CORE, "Found Dependency Locators : {}", (Object)this.dependencyLocatorList.stream().map(dependencyLocator -> "(%s:%s)".formatted(dependencyLocator.name(), dependencyLocator.getClass().getPackage().getImplementationVersion())).collect(Collectors.joining(",")));
        }
    }

    public ModValidator discoverMods() {
        List locatedFiles;
        LOGGER.debug(LogMarkers.SCAN, "Scanning for mods and other resources to load. We know {} ways to find mods", (Object)this.modLocatorList.size());
        List<ModFile> loadedFiles = new ArrayList<ModFile>();
        ArrayList<EarlyLoadingException.ExceptionData> discoveryErrorData = new ArrayList<EarlyLoadingException.ExceptionData>();
        boolean successfullyLoadedMods = true;
        ArrayList<IModFileInfo> brokenFiles = new ArrayList<IModFileInfo>();
        boolean distIsDedicatedServer = FMLLoader.getDist().isDedicatedServer();
        ImmediateWindowHandler.updateProgress("Discovering mod files");
        for (IModLocator locator : this.modLocatorList) {
            try {
                List<IModFile> clientOnlyModFiles;
                List<IModFile> badModFiles;
                LOGGER.debug(LogMarkers.SCAN, "Trying locator {}", (Object)locator);
                List candidates = locator.scanMods();
                LOGGER.debug(LogMarkers.SCAN, "Locator {} found {} candidates or errors", (Object)locator, (Object)candidates.size());
                List<ModFileLoadingException> exceptions = candidates.stream().map(IModLocator.ModFileOrException::ex).filter(Objects::nonNull).toList();
                if (!exceptions.isEmpty()) {
                    LOGGER.debug(LogMarkers.SCAN, "Locator {} found {} invalid mod files", (Object)locator, (Object)exceptions.size());
                    brokenFiles.addAll(exceptions.stream().map(e -> {
                        IModFileInfo iModFileInfo;
                        if (e instanceof InvalidModFileException) {
                            InvalidModFileException ime = (InvalidModFileException)((Object)e);
                            iModFileInfo = ime.getBrokenFile();
                        } else {
                            iModFileInfo = null;
                        }
                        return iModFileInfo;
                    }).filter(Objects::nonNull).toList());
                }
                if (!(badModFiles = (locatedFiles = candidates.stream().map(IModLocator.ModFileOrException::file).filter(Objects::nonNull).collect(Collectors.toList())).stream().filter(file -> !(file instanceof ModFile)).toList()).isEmpty()) {
                    LOGGER.error(LogMarkers.SCAN, "Locator {} returned {} files which is are not ModFile instances! They will be skipped!", (Object)locator, (Object)badModFiles.size());
                    brokenFiles.addAll(badModFiles.stream().map(IModFile::getModFileInfo).toList());
                    locatedFiles.removeAll(badModFiles);
                }
                if (distIsDedicatedServer && !(clientOnlyModFiles = locatedFiles.stream().filter(file -> file.getModFileInfo().isClientSideOnly()).toList()).isEmpty()) {
                    LOGGER.warn(LogMarkers.SCAN, "Locator {} returned {} files which are client-side-only mods, but we're on a dedicated server. They will be skipped!", (Object)locator, (Object)clientOnlyModFiles.size());
                    locatedFiles.removeAll(clientOnlyModFiles);
                }
                LOGGER.debug(LogMarkers.SCAN, "Locator {} found {} valid mod files", (Object)locator, (Object)locatedFiles.size());
                this.handleLocatedFiles(loadedFiles, locatedFiles);
            }
            catch (InvalidModFileException imfe) {
                LOGGER.error(LogMarkers.SCAN, "Locator {} found an invalid mod file {}", new Object[]{locator, imfe.getBrokenFile(), imfe});
                brokenFiles.add(imfe.getBrokenFile());
            }
            catch (EarlyLoadingException exception) {
                LOGGER.error(LogMarkers.SCAN, "Failed to load mods with locator {}", (Object)locator, (Object)exception);
                discoveryErrorData.addAll(exception.getAllData());
            }
        }
        Map<Object, Object> modFilesMap = Maps.newHashMap();
        try {
            UniqueModListBuilder modsUniqueListBuilder = new UniqueModListBuilder(loadedFiles);
            UniqueModListBuilder.UniqueModListData uniqueModsData = modsUniqueListBuilder.buildUniqueList();
            modFilesMap = uniqueModsData.modFiles().stream().collect(Collectors.groupingBy(IModFile::getType));
            loadedFiles = uniqueModsData.modFiles();
        }
        catch (EarlyLoadingException exception) {
            LOGGER.error(LogMarkers.SCAN, "Failed to build unique mod list after mod discovery.", (Throwable)exception);
            discoveryErrorData.addAll(exception.getAllData());
            successfullyLoadedMods = false;
        }
        if (successfullyLoadedMods) {
            LOGGER.debug(LogMarkers.SCAN, "Successfully Loaded {} mods. Attempting to load dependencies...", (Object)loadedFiles.size());
            for (IDependencyLocator locator : this.dependencyLocatorList) {
                try {
                    LOGGER.debug(LogMarkers.SCAN, "Trying locator {}", (Object)locator);
                    ImmutableList locatedMods = ImmutableList.copyOf(loadedFiles);
                    locatedFiles = locator.scanMods((Iterable)locatedMods);
                    if (locatedFiles.stream().anyMatch(file -> !(file instanceof ModFile))) {
                        LOGGER.error(LogMarkers.SCAN, "A dependency locator returned a file which is not a ModFile instance!. They will be skipped!");
                    }
                    this.handleLocatedFiles(loadedFiles, locatedFiles);
                }
                catch (EarlyLoadingException exception) {
                    LOGGER.error(LogMarkers.SCAN, "Failed to load dependencies with locator {}", (Object)locator, (Object)exception);
                    discoveryErrorData.addAll(exception.getAllData());
                }
            }
            try {
                UniqueModListBuilder modsAndDependenciesUniqueListBuilder = new UniqueModListBuilder(loadedFiles);
                UniqueModListBuilder.UniqueModListData uniqueModsAndDependenciesData = modsAndDependenciesUniqueListBuilder.buildUniqueList();
                modFilesMap = uniqueModsAndDependenciesData.modFiles().stream().collect(Collectors.groupingBy(IModFile::getType));
            }
            catch (EarlyLoadingException exception) {
                LOGGER.error(LogMarkers.SCAN, "Failed to build unique mod list after dependency discovery.", (Throwable)exception);
                discoveryErrorData.addAll(exception.getAllData());
                modFilesMap = loadedFiles.stream().collect(Collectors.groupingBy(IModFile::getType));
            }
        } else {
            LOGGER.error(LogMarkers.SCAN, "Mod Discovery failed. Skipping dependency discovery.");
        }
        ModValidator validator = new ModValidator(modFilesMap, brokenFiles, discoveryErrorData);
        validator.stage1Validation();
        return validator;
    }

    private void handleLocatedFiles(List<ModFile> loadedFiles, List<IModFile> locatedFiles) {
        List<ModFile> locatedModFiles = locatedFiles.stream().filter(ModFile.class::isInstance).map(ModFile.class::cast).toList();
        for (IModFile iModFile : locatedModFiles) {
            LOGGER.info(LogMarkers.SCAN, "Found mod file {} of type {} with provider {}", new Object[]{iModFile.getFileName(), iModFile.getType(), iModFile.getProvider()});
        }
        loadedFiles.addAll(locatedModFiles);
    }
}

