/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import net.minecraftforge.fml.loading.moddiscovery.AbstractModProvider;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.slf4j.Logger;

public class ModsFolderLocator
extends AbstractModProvider
implements IModLocator {
    private static final String SUFFIX = ".jar";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path modFolder;
    private final String customName;

    public ModsFolderLocator() {
        this(FMLPaths.MODSDIR.get(), "mods folder");
    }

    ModsFolderLocator(Path modFolder, String name) {
        this.modFolder = modFolder;
        this.customName = name;
    }

    public List<IModLocator.ModFileOrException> scanMods() {
        List<IModLocator.ModFileOrException> list;
        block8: {
            LOGGER.debug(LogMarkers.SCAN, "Scanning mods dir {} for mods", (Object)this.modFolder);
            List<Path> excluded = ModDirTransformerDiscoverer.allExcluded();
            Stream<Path> stream = Files.list(this.modFolder);
            try {
                list = stream.filter(path -> !excluded.contains(path) && path.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(SUFFIX)).sorted(Comparator.comparing(path -> path.getFileName().toString().toLowerCase(Locale.ROOT))).map(this::createMod).toList();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return (List)ModsFolderLocator.sneak(e);
                }
            }
            stream.close();
        }
        return list;
    }

    private static <E extends Throwable, R> R sneak(Throwable e) throws E {
        throw e;
    }

    public String name() {
        return this.customName;
    }

    public String toString() {
        return "{" + this.customName + " locator at " + String.valueOf(this.modFolder) + "}";
    }
}

