/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.ServiceRunner;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.fml.loading.targets.ArgumentList;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;
import net.minecraftforge.fml.loading.targets.UnionHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
abstract class CommonDevLaunchHandler
extends CommonLaunchHandler {
    protected CommonDevLaunchHandler(CommonLaunchHandler.LaunchType type, String prefix) {
        super(type, prefix);
    }

    @Override
    public String getNaming() {
        return "mcp";
    }

    @Override
    public boolean isProduction() {
        return false;
    }

    @Override
    protected String[] preLaunch(String[] arguments, ModuleLayer layer) {
        super.preLaunch(arguments, layer);
        if (this.getDist().isDedicatedServer()) {
            return arguments;
        }
        if (this.isData()) {
            return arguments;
        }
        ArgumentList args = ArgumentList.from(arguments);
        String username = args.get("username");
        if (username != null) {
            Matcher m = Pattern.compile("#+").matcher(username);
            StringBuffer replaced = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(replaced, CommonDevLaunchHandler.getRandomNumbers(m.group().length()));
            }
            m.appendTail(replaced);
            args.put("username", replaced.toString());
        } else {
            args.putLazy("username", "Dev");
        }
        if (!args.hasValue("accessToken")) {
            args.put("accessToken", "0");
        }
        return args.getArguments();
    }

    private static String getRandomNumbers(int length) {
        return Long.toString(System.nanoTime() % (long)((int)Math.pow(10.0, length)));
    }

    @Override
    protected ServiceRunner makeService(String[] arguments, ModuleLayer gameLayer) {
        return super.makeService(this.preLaunch(arguments, gameLayer), gameLayer);
    }

    protected static String[] findClassPath() {
        String classpath = System.getProperty("legacyClassPath");
        if (classpath == null) {
            classpath = System.getProperty("java.class.path");
        }
        return classpath.split(File.pathSeparator);
    }

    protected static Path findJarOnClasspath(String[] classpath, String match) {
        String ret = null;
        for (String entry : classpath) {
            String name;
            int idx = entry.lastIndexOf(File.separatorChar);
            if (idx == -1 || !(name = entry.substring(idx + 1)).startsWith(match)) continue;
            ret = entry;
            break;
        }
        if (ret == null) {
            throw new IllegalStateException("Could not find " + match + " in classpath");
        }
        return Paths.get(ret, new String[0]);
    }

    protected static Path getMinecraftOnly(Path extra, Path forge) {
        String[] packages = CommonDevLaunchHandler.getPackages();
        String extraPath = extra.toString().replace('\\', '/');
        BiPredicate<String, String> mcFilter = (path, base) -> {
            if (base.equals(extraPath) || path.endsWith("/")) {
                return true;
            }
            for (String pkg : packages) {
                if (!path.startsWith(pkg)) continue;
                return false;
            }
            return true;
        };
        FileSystem fs = UnionHelper.newFileSystem(mcFilter, new Path[]{forge, extra});
        return fs.getRootDirectories().iterator().next();
    }

    protected static Path getForgeOnly(Path forge) {
        String[] packages = CommonDevLaunchHandler.getPackages();
        SecureJar modJar = SecureJar.from((path, base) -> {
            if (!path.endsWith(".class")) {
                return true;
            }
            for (String pkg : packages) {
                if (!path.startsWith(pkg)) continue;
                return true;
            }
            return false;
        }, (Path[])new Path[]{forge});
        return modJar.getRootPath();
    }

    private static String[] getPackages() {
        return new String[]{"net/minecraftforge/", "META-INF/services/", "META-INF/coremods.json", "META-INF/mods.toml"};
    }
}

