/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.google.common.collect.Streams;
import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.api.distmarker.OnlyIns;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class RuntimeDistCleaner
implements ILaunchPluginService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Marker DISTXFORM = MarkerFactory.getMarker((String)"DISTXFORM");
    private static String DIST;
    private static final String ONLYIN;
    private static final String ONLYINS;
    private static final EnumSet<ILaunchPluginService.Phase> YAY;
    private static final EnumSet<ILaunchPluginService.Phase> NAY;

    public String name() {
        return "runtimedistcleaner";
    }

    public int processClassWithFlags(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        AtomicBoolean changes = new AtomicBoolean();
        if (RuntimeDistCleaner.remove(classNode.visibleAnnotations, DIST)) {
            LOGGER.error(DISTXFORM, "Attempted to load class {} for invalid dist {}", (Object)classNode.name, (Object)DIST);
            throw new RuntimeException("Attempted to load class " + classNode.name + " for invalid dist " + DIST);
        }
        if (!FMLEnvironment.production && RuntimeDistCleaner.hasOnlyInWithModAnnotation(classNode.visibleAnnotations)) {
            LOGGER.error(DISTXFORM, "Attempted to load class {} with @Mod and @OnlyIn/@OnlyIns annotations", (Object)classNode.name);
            throw new RuntimeException("Found @OnlyIn on @Mod class " + classNode.name + " - this is not allowed as it causes crashes. Remove the OnlyIn and consider setting clientSideOnly=true in the root of your mods.toml instead");
        }
        if (classNode.interfaces != null) {
            RuntimeDistCleaner.unpack(classNode.visibleAnnotations).stream().filter(ann -> Objects.equals(ann.desc, ONLYIN)).filter(ann -> ann.values.contains("_interface")).filter(ann -> !Objects.equals(((String[])ann.values.get(ann.values.indexOf("value") + 1))[1], DIST)).map(ann -> ((Type)ann.values.get(ann.values.indexOf("_interface") + 1)).getInternalName()).forEach(intf -> {
                if (classNode.interfaces.remove(intf)) {
                    LOGGER.debug(DISTXFORM, "Removing Interface: {} implements {}", (Object)classNode.name, intf);
                    changes.compareAndSet(false, true);
                }
            });
            if (classNode.visibleAnnotations != null) {
                Iterator itr = classNode.visibleAnnotations.iterator();
                while (itr.hasNext()) {
                    AnnotationNode ann2 = (AnnotationNode)itr.next();
                    if (!Objects.equals(ann2.desc, ONLYIN) && !Objects.equals(ann2.desc, ONLYINS)) continue;
                    LOGGER.debug(DISTXFORM, "Removing Class Annotation: {} @{}", (Object)classNode.name, (Object)ann2.desc);
                    itr.remove();
                    changes.compareAndSet(false, true);
                }
            }
        }
        Iterator fields = classNode.fields.iterator();
        while (fields.hasNext()) {
            FieldNode field = (FieldNode)fields.next();
            if (!RuntimeDistCleaner.remove(field.visibleAnnotations, DIST)) continue;
            LOGGER.debug(DISTXFORM, "Removing field: {}.{}", (Object)classNode.name, (Object)field.name);
            fields.remove();
            changes.compareAndSet(false, true);
        }
        LambdaGatherer lambdaGatherer = new LambdaGatherer();
        Iterator methods = classNode.methods.iterator();
        while (methods.hasNext()) {
            MethodNode method = (MethodNode)methods.next();
            if (!RuntimeDistCleaner.remove(method.visibleAnnotations, DIST)) continue;
            LOGGER.debug(DISTXFORM, "Removing method: {}.{}{}", new Object[]{classNode.name, method.name, method.desc});
            methods.remove();
            lambdaGatherer.accept(method);
            changes.compareAndSet(false, true);
        }
        List<Handle> dynamicLambdaHandles = lambdaGatherer.getDynamicLambdaHandles();
        while (!dynamicLambdaHandles.isEmpty()) {
            lambdaGatherer = new LambdaGatherer();
            methods = classNode.methods.iterator();
            while (methods.hasNext()) {
                MethodNode method = (MethodNode)methods.next();
                if ((method.access & 0x1000) == 0) continue;
                for (Handle dynamicLambdaHandle : dynamicLambdaHandles) {
                    if (!method.name.equals(dynamicLambdaHandle.getName()) || !method.desc.equals(dynamicLambdaHandle.getDesc())) continue;
                    LOGGER.debug(DISTXFORM, "Removing lambda method: {}.{}{}", new Object[]{classNode.name, method.name, method.desc});
                    methods.remove();
                    lambdaGatherer.accept(method);
                    changes.compareAndSet(false, true);
                }
            }
            dynamicLambdaHandles = lambdaGatherer.getDynamicLambdaHandles();
        }
        return changes.get() ? 256 : 0;
    }

    private static List<AnnotationNode> unpack(List<AnnotationNode> anns) {
        if (anns == null) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationNode> unpacked = new ArrayList<AnnotationNode>();
        for (AnnotationNode annotationNode : anns) {
            List subNodes;
            if (!Objects.equals(annotationNode.desc, ONLYINS)) continue;
            unpacked.add(annotationNode);
            if (annotationNode.values == null || (subNodes = (List)annotationNode.values.get(annotationNode.values.indexOf("value") + 1)) == null) continue;
            unpacked.addAll(subNodes);
        }
        return unpacked;
    }

    private static boolean remove(List<AnnotationNode> anns, String side) {
        List<AnnotationNode> onlyIns = RuntimeDistCleaner.unpack(anns);
        for (AnnotationNode onlyIn : onlyIns) {
            if (!Objects.equals(onlyIn.desc, ONLYINS) || onlyIn.values.contains("_interface") || Objects.equals(((String[])onlyIn.values.get(onlyIn.values.indexOf("value") + 1))[1], side)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOnlyInWithModAnnotation(List<AnnotationNode> anns) {
        if (anns == null) {
            return false;
        }
        boolean foundModAnnotation = false;
        boolean foundOnlyIn = false;
        for (AnnotationNode ann : anns) {
            if (ann.desc.equals("Lnet/minecraftforge/fml/common/Mod;")) {
                foundModAnnotation = true;
                continue;
            }
            if (!Objects.equals(ann.desc, ONLYIN) && !Objects.equals(ann.desc, ONLYINS)) continue;
            foundOnlyIn = true;
        }
        return foundModAnnotation && foundOnlyIn;
    }

    public Consumer<Dist> getExtension() {
        return s -> {
            DIST = s.name();
            LOGGER.debug(DISTXFORM, "Configuring for Dist {}", (Object)DIST);
        };
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        if (isEmpty) {
            return NAY;
        }
        String internalName = classType.getInternalName();
        if (internalName.startsWith("net/minecraftforge/")) {
            return NAY;
        }
        return YAY;
    }

    static {
        ONLYIN = Type.getDescriptor(OnlyIn.class);
        ONLYINS = Type.getDescriptor(OnlyIns.class);
        YAY = EnumSet.of(ILaunchPluginService.Phase.AFTER);
        NAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);
    }

    private static class LambdaGatherer
    extends MethodVisitor {
        private static final Handle META_FACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
        private final List<Handle> dynamicLambdaHandles = new ArrayList<Handle>();

        public LambdaGatherer() {
            super(589824);
        }

        public void accept(MethodNode method) {
            Streams.stream((Iterator)method.instructions.iterator()).filter(insnNode -> insnNode.getType() == 6).forEach(insnNode -> insnNode.accept((MethodVisitor)this));
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if (META_FACTORY.equals((Object)bsm)) {
                Handle dynamicLambdaHandle = (Handle)bsmArgs[1];
                this.dynamicLambdaHandles.add(dynamicLambdaHandle);
            }
        }

        public List<Handle> getDynamicLambdaHandles() {
            return this.dynamicLambdaHandles;
        }
    }
}

