/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraftforge.fml.loading.StringSubstitutor;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.MavenVersionAdapter;
import net.minecraftforge.forgespi.locating.ForgeFeature;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public class ModInfo
implements IModInfo,
IConfigurable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DefaultArtifactVersion DEFAULT_VERSION = new DefaultArtifactVersion("1");
    private static final Pattern VALID_MODID = Pattern.compile("^[a-z][a-z0-9_]{1,63}$");
    private static final Pattern VALID_NAMESPACE = Pattern.compile("^[a-z][a-z0-9_.-]{1,63}$");
    private static final Pattern VALID_VERSION = Pattern.compile("^\\d+.*");
    private final ModFileInfo owningFile;
    private final String modId;
    private final String namespace;
    private final ArtifactVersion version;
    private final String displayName;
    private final String description;
    private final Optional<String> logoFile;
    private final boolean logoBlur;
    private final Optional<URL> updateJSONURL;
    private final List<? extends IModInfo.ModVersion> dependencies;
    private final List<ForgeFeature.Bound> features;
    private final Map<String, Object> properties;
    private final IConfigurable config;
    private final Optional<URL> modUrl;

    public ModInfo(ModFileInfo owningFile, IConfigurable config) {
        Optional<ModFileInfo> ownFile = Optional.ofNullable(owningFile);
        this.owningFile = owningFile;
        this.config = config;
        this.modId = (String)config.getConfigElement(new String[]{"modId"}).orElseThrow(() -> new InvalidModFileException("Missing modId", owningFile));
        if (!VALID_MODID.matcher(this.modId).matches()) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Invalid modId found in file {} - {} does not match the standard: {}", new Object[]{this.owningFile.getFile().getFilePath(), this.modId, VALID_MODID.pattern()});
            throw new InvalidModFileException("Invalid modId found : " + this.modId, owningFile);
        }
        this.namespace = config.getConfigElement(new String[]{"namespace"}).orElse(this.modId);
        if (!VALID_NAMESPACE.matcher(this.namespace).matches()) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Invalid override namespace found in file {} - {} does not match the standard: {}", new Object[]{this.owningFile.getFile().getFilePath(), this.namespace, VALID_NAMESPACE.pattern()});
            throw new InvalidModFileException("Invalid override namespace found : " + this.namespace, owningFile);
        }
        this.version = (ArtifactVersion)config.getConfigElement(new String[]{"version"}).map(s -> StringSubstitutor.replace(s, ownFile.map(ModFileInfo::getFile).orElse(null))).map(DefaultArtifactVersion::new).orElse(DEFAULT_VERSION);
        if (!VALID_VERSION.matcher(this.version.toString()).matches()) {
            throw new InvalidModFileException("Illegal version number specified " + String.valueOf(this.version), this.getOwningFile());
        }
        this.displayName = config.getConfigElement(new String[]{"displayName"}).orElse(this.modId);
        this.description = config.getConfigElement(new String[]{"description"}).orElse("MISSING DESCRIPTION").replace("\r\n", "\n").stripIndent();
        this.logoFile = Optional.ofNullable(config.getConfigElement(new String[]{"logoFile"}).orElseGet(() -> ownFile.flatMap(mf -> mf.getConfigElement("logoFile")).orElse(null)));
        this.logoBlur = config.getConfigElement(new String[]{"logoBlur"}).orElseGet(() -> ownFile.flatMap(mf -> mf.getConfigElement("logoBlur")).orElse(true));
        this.updateJSONURL = config.getConfigElement(new String[]{"updateJSONURL"}).map(StringUtils::toURL);
        this.modUrl = config.getConfigElement(new String[]{"modUrl"}).map(StringUtils::toURL);
        if (ownFile.isEmpty()) {
            this.dependencies = Collections.emptyList();
            this.features = Collections.emptyList();
            this.properties = Collections.emptyMap();
        } else {
            List<? extends IConfigurable> deps = this.owningFile.getConfigList("dependencies", this.modId);
            if (deps == null || deps.isEmpty()) {
                this.dependencies = Collections.emptyList();
            } else {
                ArrayList<ModVersion> tmp = new ArrayList<ModVersion>();
                for (IConfigurable iConfigurable : deps) {
                    tmp.add(new ModVersion(this, iConfigurable));
                }
                this.dependencies = Collections.unmodifiableList(tmp);
            }
            Map feats = this.owningFile.getConfigElement("features", this.modId).orElse(null);
            if (feats == null) {
                this.features = Collections.emptyList();
            } else {
                ArrayList<ForgeFeature.Bound> tmp = new ArrayList<ForgeFeature.Bound>();
                for (Map.Entry entry : feats.entrySet()) {
                    Object v = entry.getValue();
                    if (!(v instanceof String)) {
                        throw new InvalidModFileException("Invalid feature bound {" + String.valueOf(entry.getValue()) + "} for key {" + (String)entry.getKey() + "} only strings are accepted", this.owningFile);
                    }
                    String val = (String)v;
                    tmp.add(new ForgeFeature.Bound((String)entry.getKey(), val, (IModInfo)this));
                }
                this.features = Collections.unmodifiableList(tmp);
            }
            Map props = this.owningFile.getConfigElement("modproperties", this.modId).orElse(null);
            this.properties = props == null ? Collections.emptyMap() : Collections.unmodifiableMap(props);
        }
    }

    public ModFileInfo getOwningFile() {
        return this.owningFile;
    }

    public String getModId() {
        return this.modId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public ArtifactVersion getVersion() {
        return this.version;
    }

    public List<? extends IModInfo.ModVersion> getDependencies() {
        return this.dependencies;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, Object> getModProperties() {
        return this.properties;
    }

    public Optional<URL> getUpdateURL() {
        return this.updateJSONURL;
    }

    public Optional<String> getLogoFile() {
        return this.logoFile;
    }

    public boolean getLogoBlur() {
        return this.logoBlur;
    }

    public IConfigurable getConfig() {
        return this;
    }

    public List<? extends ForgeFeature.Bound> getForgeFeatures() {
        return this.features;
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        return this.config.getConfigElement(key);
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        return null;
    }

    public Optional<URL> getModURL() {
        return this.modUrl;
    }

    class ModVersion
    implements IModInfo.ModVersion {
        private IModInfo owner;
        private final String modId;
        private final VersionRange versionRange;
        private final boolean mandatory;
        private final IModInfo.Ordering ordering;
        private final IModInfo.DependencySide side;
        private final Optional<URL> referralUrl;

        public ModVersion(IModInfo owner, IConfigurable config) {
            Optional mandatory;
            Map fileProps;
            this.owner = owner;
            this.modId = (String)config.getConfigElement(new String[]{"modId"}).orElseThrow(() -> new InvalidModFileException("Missing required field modid in dependency", ModInfo.this.getOwningFile()));
            if (this.modId.equals("forge") && !(fileProps = owner.getOwningFile().getFileProperties()).isEmpty() && fileProps.containsKey("__FORGE__not_a_forge_mod")) {
                fileProps.remove("__FORGE__not_a_forge_mod");
            }
            if ((mandatory = config.getConfigElement(new String[]{"mandatory"})).isPresent()) {
                this.mandatory = (Boolean)mandatory.get();
            } else if (owner.getOwningFile().getFileProperties().containsKey("__FORGE__not_a_forge_mod")) {
                this.mandatory = true;
            } else {
                throw new InvalidModFileException("Missing required field mandatory in dependency", ModInfo.this.getOwningFile());
            }
            this.versionRange = config.getConfigElement(new String[]{"versionRange"}).map(MavenVersionAdapter::createFromVersionSpec).orElse(IModInfo.UNBOUNDED);
            this.ordering = config.getConfigElement(new String[]{"ordering"}).map(IModInfo.Ordering::valueOf).orElse(IModInfo.Ordering.NONE);
            this.side = config.getConfigElement(new String[]{"side"}).map(IModInfo.DependencySide::valueOf).orElse(IModInfo.DependencySide.BOTH);
            this.referralUrl = config.getConfigElement(new String[]{"referralUrl"}).map(StringUtils::toURL);
        }

        public String getModId() {
            return this.modId;
        }

        public VersionRange getVersionRange() {
            return this.versionRange;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public IModInfo.Ordering getOrdering() {
            return this.ordering;
        }

        public IModInfo.DependencySide getSide() {
            return this.side;
        }

        public void setOwner(IModInfo owner) {
            this.owner = owner;
        }

        public IModInfo getOwner() {
            return this.owner;
        }

        public Optional<URL> getReferralURL() {
            return this.referralUrl;
        }
    }
}

