/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import net.minecraftforge.fml.loading.JarVersionLookupHandler;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;

public class LanguageLoadingProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ServiceLoader<IModLanguageProvider> serviceLoader;
    private final List<IModLanguageProvider> providers = new ArrayList<IModLanguageProvider>();
    private final Map<String, Wrapper> providersByName = new HashMap<String, Wrapper>();
    private static final DefaultArtifactVersion IN_DEV = new DefaultArtifactVersion("0.0-dev");

    public void forEach(Consumer<IModLanguageProvider> consumer) {
        this.providers.forEach(consumer);
    }

    public <T> Stream<T> applyForEach(Function<IModLanguageProvider, T> function) {
        return this.providers.stream().map(function);
    }

    public void reload() {
        this.loadLanguageProviders();
    }

    @Deprecated(forRemoval=true, since="1.20.2")
    public void addAdditionalLanguages(List<ModFile> modFiles) {
        this.reload();
    }

    LanguageLoadingProvider() {
        ModuleLayer sl = (ModuleLayer)Launcher.INSTANCE.environment().findModuleLayerManager().flatMap(lm -> lm.getLayer(IModuleLayerManager.Layer.PLUGIN)).orElseThrow();
        this.serviceLoader = ServiceLoader.load(sl, IModLanguageProvider.class);
        this.loadLanguageProviders();
    }

    private void loadLanguageProviders() {
        this.providers.clear();
        this.providersByName.clear();
        this.serviceLoader.reload();
        Iterator<IModLanguageProvider> itr = this.serviceLoader.iterator();
        while (itr.hasNext()) {
            try {
                IModLanguageProvider srvc = itr.next();
                this.providers.add(srvc);
            }
            catch (ServiceConfigurationError sce) {
                LOGGER.error(LogMarkers.CORE, "Failed to load IModLauguageProvider Service: " + sce.getMessage());
            }
        }
        LOGGER.debug(LogMarkers.CORE, "Found {} language providers", (Object)this.providers.size());
        ImmediateWindowHandler.updateProgress("Loading language providers");
        for (IModLanguageProvider provider : this.providers) {
            JarVersionLookupHandler.Info info = JarVersionLookupHandler.getInfo(provider.getClass());
            if (info.impl().version().isEmpty() && FMLEnvironment.production) {
                LOGGER.error(LogMarkers.CORE, "Found unversioned language provider {}: {}", (Object)provider.name(), (Object)provider.getClass().getName());
                throw new RuntimeException("Failed to find implementation version for language provider " + provider.name() + " of type " + provider.getClass().getName());
            }
            DefaultArtifactVersion version = info.impl().version().map(DefaultArtifactVersion::new).orElse(IN_DEV);
            LOGGER.debug(LogMarkers.CORE, "Found language provider {}, version {}", (Object)provider.name(), (Object)version);
            ImmediateWindowHandler.updateProgress("Loaded language provider " + provider.name() + " " + String.valueOf(version));
            this.providersByName.put(provider.name(), new Wrapper((ArtifactVersion)version, provider));
        }
    }

    public IModLanguageProvider findLanguage(ModFile mod, String language, VersionRange versionRange) {
        String consumer = mod.getFileName();
        Wrapper wrapper = this.providersByName.get(language);
        if (wrapper == null) {
            LOGGER.error(LogMarkers.LOADING, "Missing language {} version {} wanted by {}", new Object[]{language, versionRange, consumer});
            EarlyLoadingException.ExceptionData data = new EarlyLoadingException.ExceptionData("fml.language.missingversion", language, versionRange, consumer, "null");
            throw new EarlyLoadingException("Missing language " + language, null, List.of(data));
        }
        ArtifactVersion version = wrapper.version();
        if (version == IN_DEV) {
            LOGGER.debug(LogMarkers.LOADING, "Language Provider {} version is unknown, but {} was requested by {}. Proceeding as this is development environement", new Object[]{language, versionRange, consumer});
            return wrapper.service();
        }
        if (!versionRange.containsVersion(version)) {
            LOGGER.error(LogMarkers.LOADING, "Missing language {} version {} wanted by {}, found {}", new Object[]{language, versionRange, consumer, version});
            EarlyLoadingException.ExceptionData data = new EarlyLoadingException.ExceptionData("fml.language.missingversion", language, versionRange, consumer, version);
            throw new EarlyLoadingException("Missing language " + language + " matching range " + String.valueOf(versionRange) + " found " + String.valueOf(version), null, List.of(data));
        }
        return wrapper.service();
    }

    private record Wrapper(ArtifactVersion version, IModLanguageProvider service) {
    }
}

