/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.fml.loading.moddiscovery.ModJarMetadata;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.IModProvider;
import net.minecraftforge.forgespi.locating.ModFileLoadingException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public abstract class AbstractModProvider
implements IModProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final String MODS_TOML = "META-INF/mods.toml";
    protected static final String MODULE_INFO = "module-info.class";

    protected IModLocator.ModFileOrException createMod(Path path) {
        return this.createMod(path, false);
    }

    @Nullable
    protected IModLocator.ModFileOrException createMod(Path path, boolean ignoreUnknown) {
        return this.createMod(path, ignoreUnknown, this.getDefaultJarModType());
    }

    @Nullable
    protected IModLocator.ModFileOrException createMod(Path path, boolean ignoreUnknown, String defaultType) {
        ModFile mod;
        ModJarMetadata mjm = new ModJarMetadata();
        SecureJar sj = null;
        try {
            sj = SecureJar.from(jar -> AbstractModProvider.loadMetaFromJar(jar, mjm), (Path[])new Path[]{path});
        }
        catch (Throwable t) {
            return new IModLocator.ModFileOrException(null, new ModFileLoadingException("Failed to create secure jar for \"" + String.valueOf(path) + "\" - " + t.getMessage()));
        }
        String type = sj.moduleDataProvider().getManifest().getMainAttributes().getValue(ModFile.TYPE);
        if (type == null) {
            type = defaultType;
        }
        if (sj.moduleDataProvider().findFile(MODS_TOML).isPresent()) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", new Object[]{MODS_TOML, type, path});
            mod = new ModFile(sj, this, ModFileParser::modsTomlParser);
            mjm.setModFile(mod);
            if (mod.getModFileInfo().getFileProperties().containsKey("__FORGE__not_a_forge_mod")) {
                LOGGER.error(LogMarkers.SCAN, "Unable to load file \"{}\" because its mods.toml is requesting an invalid javafml loaderVersion (use \"*\" if you want to allow all versions) and is missing a forge modId dependency declaration (see the sample mods.toml in the MDK).", (Object)path);
                return new IModLocator.ModFileOrException(null, new ModFileLoadingException("File \"%s\" is not a Forge mod and cannot be loaded. Look for a Forge version of this mod or consider alternative mods.".formatted(mod.getFileName())));
            }
        } else if (type != null) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", new Object[]{"META-INF/MANIFEST.MF", type, path});
            mod = new ModFile(sj, this, this::manifestParser, type);
        } else {
            if (ignoreUnknown) {
                return null;
            }
            return new IModLocator.ModFileOrException(null, new ModFileLoadingException("Invalid mod file found " + String.valueOf(path)));
        }
        return new IModLocator.ModFileOrException((IModFile)mod, null);
    }

    protected static JarMetadata loadMetaFromJar(SecureJar jar, ModJarMetadata mjm) {
        InputStream info = jar.moduleDataProvider().open(MODULE_INFO).orElse(null);
        if (info != null) {
            try {
                final ModuleDescriptor desc = ModuleDescriptor.read(info, () -> ((SecureJar)jar).getPackages());
                HashSet all = new HashSet(jar.getPackages());
                all.removeAll(desc.packages());
                if (!all.isEmpty()) {
                    String missing = all.stream().sorted().collect(Collectors.joining(", "));
                    LOGGER.error("Invalid module-info, missing packages " + missing);
                    throw new ModFileLoadingException("Invalid module-info, missing packages " + missing);
                }
                JarMetadata jarMetadata = new JarMetadata(){

                    public String name() {
                        return desc.name();
                    }

                    public String version() {
                        return desc.version().map(ModuleDescriptor.Version::toString).or(desc::rawVersion).orElse(null);
                    }

                    public ModuleDescriptor descriptor() {
                        return desc;
                    }
                };
                return jarMetadata;
            }
            catch (IOException | InvalidModuleDescriptorException e) {
                LOGGER.error("Failed to parse " + String.valueOf(jar.getPrimaryPath()) + " module-info", (Throwable)e);
                throw new ModFileLoadingException("Invalid module-info: " + e.getMessage());
            }
            finally {
                try {
                    info.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (jar.moduleDataProvider().findFile(MODS_TOML).isEmpty()) {
            return JarMetadata.from((SecureJar)jar, (Path[])new Path[]{jar.getPrimaryPath()});
        }
        return mjm;
    }

    protected IModFileInfo manifestParser(IModFile mod) {
        Attributes mf = mod.getSecureJar().moduleDataProvider().getManifest().getMainAttributes();
        String license = mf.getValue("LICENSE");
        IConfigurable dummy = new IConfigurable(this){

            public <T> Optional<T> getConfigElement(String key) {
                return Optional.empty();
            }

            public <T> Optional<T> getConfigElement(String ... key) {
                return Optional.empty();
            }

            public List<? extends IConfigurable> getConfigList(String key) {
                return Collections.emptyList();
            }

            public List<? extends IConfigurable> getConfigList(String ... key) {
                return Collections.emptyList();
            }
        };
        return new DefaultModFileInfo(mod, license == null ? "" : license, dummy);
    }

    public boolean isValid(IModFile modFile) {
        return true;
    }

    public void initArguments(Map<String, ?> arguments) {
    }

    protected String getDefaultJarModType() {
        return null;
    }

    public void scanFile(IModFile file, Consumer<Path> pathConsumer) {
        LOGGER.debug(LogMarkers.SCAN, "Scan started: {}", (Object)file);
        SecureJar jar = file.getSecureJar();
        Path root = jar.getRootPath();
        Consumer<Path> consumer = pathConsumer;
        Holder holder = new Holder();
        holder.value = SecureJar.Status.NONE;
        if (jar.hasSecurityData()) {
            consumer = path -> {
                pathConsumer.accept((Path)path);
                SecureJar.Status status = jar.verifyPath(path);
                if (status.ordinal() < ((SecureJar.Status)holder.value).ordinal()) {
                    holder.value = status;
                }
            };
        }
        try (Stream<Path> files = Files.walk(root, new FileVisitOption[0]);){
            files.filter(p -> p.toString().endsWith(".class")).forEach(consumer);
            file.setSecurityStatus((SecureJar.Status)holder.value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.debug(LogMarkers.SCAN, "Scan finished: {}", (Object)file);
    }

    private record DefaultModFileInfo(IModFile mod, String license, IConfigurable configurable) implements IModFileInfo,
    IConfigurable
    {
        public <T> Optional<T> getConfigElement(String string) {
            return Optional.empty();
        }

        public <T> Optional<T> getConfigElement(String ... strings) {
            return Optional.empty();
        }

        public List<? extends IConfigurable> getConfigList(String ... strings) {
            return null;
        }

        public List<IModInfo> getMods() {
            return Collections.emptyList();
        }

        public List<IModFileInfo.LanguageSpec> requiredLanguageLoaders() {
            return Collections.emptyList();
        }

        public boolean showAsResourcePack() {
            return false;
        }

        public boolean showAsDataPack() {
            return false;
        }

        public Map<String, Object> getFileProperties() {
            return Collections.emptyMap();
        }

        public String getLicense() {
            return this.license;
        }

        public IModFile getFile() {
            return this.mod;
        }

        public IConfigurable getConfig() {
            return this.configurable;
        }

        public String moduleName() {
            return this.mod.getSecureJar().name();
        }

        public String versionString() {
            return null;
        }

        public List<String> usesServices() {
            return null;
        }

        @Override
        public String toString() {
            return "IModFileInfo(" + String.valueOf(this.mod.getFilePath()) + ")";
        }
    }

    private static final class Holder<T> {
        private T value;

        private Holder() {
        }
    }
}

