/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.api.distmarker.OnlyIns;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class RuntimeDistCleaner
implements ILaunchPluginService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Marker DISTXFORM = MarkerFactory.getMarker((String)"DISTXFORM");
    private static String DIST;
    private static final String ONLYIN;
    private static final String ONLYINS;
    private static final String MOD = "Lnet/minecraftforge/fml/common/Mod;";
    private static final EnumSet<ILaunchPluginService.Phase> YAY;
    private static final EnumSet<ILaunchPluginService.Phase> NAY;

    public String name() {
        return "runtimedistcleaner";
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        if (isEmpty) {
            return NAY;
        }
        String internalName = classType.getInternalName();
        if (internalName.startsWith("net/minecraftforge/")) {
            return NAY;
        }
        return YAY;
    }

    public int processClassWithFlags(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        Iterator itr;
        boolean changed = false;
        List<Target> annotations = RuntimeDistCleaner.unpack(classNode.visibleAnnotations);
        if (RuntimeDistCleaner.remove(annotations, DIST)) {
            LOGGER.error(DISTXFORM, "Attempted to load class {} for invalid dist {}", (Object)classNode.name, (Object)DIST);
            throw new RuntimeException("Attempted to load class " + classNode.name + " for invalid dist " + DIST);
        }
        if (!FMLEnvironment.production && !annotations.isEmpty() && RuntimeDistCleaner.hasModAnnotation(classNode.visibleAnnotations)) {
            LOGGER.error(DISTXFORM, "Attempted to load class {} with @Mod and @OnlyIn/@OnlyIns annotations", (Object)classNode.name);
            throw new RuntimeException("Found @OnlyIn on @Mod class " + classNode.name + " - this is not allowed as it causes crashes. Remove the OnlyIn and consider setting clientSideOnly=true in the root of your mods.toml instead");
        }
        if (classNode.interfaces != null && !classNode.interfaces.isEmpty()) {
            for (Target ann : annotations) {
                if (ann.intf == null || DIST.equals(ann.side) || !classNode.interfaces.remove(ann.intf)) continue;
                LOGGER.debug(DISTXFORM, "Removing Interface: {} implements {}", (Object)classNode.name, (Object)ann.intf);
                changed = true;
            }
            if (classNode.visibleAnnotations != null) {
                itr = classNode.visibleAnnotations.iterator();
                while (itr.hasNext()) {
                    Target ann;
                    ann = (AnnotationNode)itr.next();
                    if (!ONLYIN.equals(((AnnotationNode)ann).desc) && !ONLYINS.equals(((AnnotationNode)ann).desc)) continue;
                    LOGGER.debug(DISTXFORM, "Removing Class Annotation: {} @{}", (Object)classNode.name, (Object)((AnnotationNode)ann).desc);
                    itr.remove();
                    changed = true;
                }
            }
        }
        itr = classNode.fields.iterator();
        while (itr.hasNext()) {
            FieldNode field = (FieldNode)itr.next();
            if (!RuntimeDistCleaner.remove(RuntimeDistCleaner.unpack(field.visibleAnnotations), DIST)) continue;
            LOGGER.debug(DISTXFORM, "Removing field: {}.{}", (Object)classNode.name, (Object)field.name);
            itr.remove();
            changed = true;
        }
        LambdaGatherer lambdaGatherer = new LambdaGatherer();
        Iterator itr2 = classNode.methods.iterator();
        while (itr2.hasNext()) {
            MethodNode method = (MethodNode)itr2.next();
            if (!RuntimeDistCleaner.remove(RuntimeDistCleaner.unpack(method.visibleAnnotations), DIST)) continue;
            LOGGER.debug(DISTXFORM, "Removing method: {}.{}{}", new Object[]{classNode.name, method.name, method.desc});
            itr2.remove();
            lambdaGatherer.accept(method);
            changed = true;
        }
        List<Handle> handles = lambdaGatherer.getDynamicLambdaHandles();
        while (!handles.isEmpty()) {
            lambdaGatherer = new LambdaGatherer();
            Iterator itr3 = classNode.methods.iterator();
            while (itr3.hasNext()) {
                MethodNode method = (MethodNode)itr3.next();
                if ((method.access & 0x1000) == 0) continue;
                for (Handle handle : handles) {
                    if (!method.name.equals(handle.getName()) || !method.desc.equals(handle.getDesc())) continue;
                    LOGGER.debug(DISTXFORM, "Removing lambda method: {}.{}{}", new Object[]{classNode.name, method.name, method.desc});
                    itr3.remove();
                    lambdaGatherer.accept(method);
                    changed = true;
                }
            }
            handles = lambdaGatherer.getDynamicLambdaHandles();
        }
        return changed ? 256 : 0;
    }

    private static List<Target> unpack(List<AnnotationNode> anns) {
        if (anns == null || anns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Target> ret = new ArrayList<Target>();
        for (AnnotationNode node : anns) {
            List subNodes;
            int idx;
            if (ONLYIN.equals(node.desc)) {
                ret.add(Target.from(node));
                continue;
            }
            if (!ONLYINS.equals(node.desc) || node.values == null || node.values.isEmpty() || (idx = node.values.indexOf("value")) == -1 || (subNodes = (List)node.values.get(idx + 1)) == null) continue;
            for (AnnotationNode sub : subNodes) {
                ret.add(Target.from(sub));
            }
        }
        return ret;
    }

    private static boolean remove(List<Target> targets, String side) {
        for (Target target : targets) {
            if (target.intf != null || side.equals(target.side)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasModAnnotation(List<AnnotationNode> anns) {
        if (anns == null || anns.isEmpty()) {
            return false;
        }
        for (AnnotationNode ann : anns) {
            if (!ann.desc.equals(MOD)) continue;
            return true;
        }
        return false;
    }

    public Consumer<Dist> getExtension() {
        return s -> {
            DIST = s.name();
            LOGGER.debug(DISTXFORM, "Configuring for Dist {}", (Object)DIST);
        };
    }

    static {
        ONLYIN = Type.getDescriptor(OnlyIn.class);
        ONLYINS = Type.getDescriptor(OnlyIns.class);
        YAY = EnumSet.of(ILaunchPluginService.Phase.AFTER);
        NAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);
    }

    private record Target(String side, String intf) {
        static Target from(AnnotationNode node) {
            int idx = node.values.indexOf("value");
            String[] value = (String[])node.values.get(idx + 1);
            idx = node.values.indexOf("_interface");
            if (idx == -1) {
                return new Target(value[1], null);
            }
            Type intf = (Type)node.values.get(idx + 1);
            return new Target(value[1], intf.getInternalName());
        }
    }

    private static class LambdaGatherer
    extends MethodVisitor {
        private static final Handle META_FACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
        private final List<Handle> dynamicLambdaHandles = new ArrayList<Handle>();

        public LambdaGatherer() {
            super(589824);
        }

        public void accept(MethodNode method) {
            for (AbstractInsnNode insn : method.instructions) {
                if (insn.getType() != 6) continue;
                insn.accept((MethodVisitor)this);
            }
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if (META_FACTORY.equals((Object)bsm)) {
                Handle handle = (Handle)bsmArgs[1];
                this.dynamicLambdaHandles.add(handle);
            }
        }

        public List<Handle> getDynamicLambdaHandles() {
            return this.dynamicLambdaHandles;
        }
    }
}

