/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class FMLMissingMappingsEvent
extends FMLEvent {
    private ListMultimap<String, MissingMapping> missing;
    private ModContainer activeContainer;

    public FMLMissingMappingsEvent(ListMultimap<String, MissingMapping> missingMappings) {
        this.missing = missingMappings;
    }

    @Override
    public void applyModContainer(ModContainer activeContainer) {
        super.applyModContainer(activeContainer);
        this.activeContainer = activeContainer;
    }

    public List<MissingMapping> get() {
        return ImmutableList.copyOf((Collection)this.missing.get((Object)this.activeContainer.getModId()));
    }

    public List<MissingMapping> getAll() {
        return ImmutableList.copyOf((Collection)this.missing.values());
    }

    public static class MissingMapping {
        public final GameRegistry.Type type;
        public final String name;
        public final int id;
        public final kn resourceLocation;
        private Action action = Action.DEFAULT;
        private Object target;

        public MissingMapping(GameRegistry.Type type, kn name, int id) {
            this.type = type;
            this.name = name.toString();
            this.id = id;
            this.resourceLocation = name;
        }

        public void ignore() {
            this.action = Action.IGNORE;
        }

        public void warn() {
            this.action = Action.WARN;
        }

        public void fail() {
            this.action = Action.FAIL;
        }

        public void remap(akf target) {
            if (this.type != GameRegistry.Type.BLOCK) {
                throw new IllegalArgumentException("Can't remap an item to a block.");
            }
            if (target == null) {
                throw new NullPointerException("remap target is null");
            }
            if (GameData.getBlockRegistry().getId(target) < 0) {
                throw new IllegalArgumentException(String.format("The specified block %s hasn't been registered at startup.", target));
            }
            this.action = Action.REMAP;
            this.target = target;
        }

        public void remap(adx target) {
            if (this.type != GameRegistry.Type.ITEM) {
                throw new IllegalArgumentException("Can't remap a block to an item.");
            }
            if (target == null) {
                throw new NullPointerException("remap target is null");
            }
            if (GameData.getItemRegistry().getId(target) < 0) {
                throw new IllegalArgumentException(String.format("The specified item %s hasn't been registered at startup.", target));
            }
            this.action = Action.REMAP;
            this.target = target;
        }

        public void skipItemBlock() {
            if (this.type != GameRegistry.Type.ITEM) {
                throw new IllegalArgumentException("Cannot skip an item that is a block");
            }
            if (GameData.getBlockRegistry().getRaw(this.id) == null) {
                throw new IllegalArgumentException("Cannot skip an ItemBlock that doesn't have a Block");
            }
            this.action = Action.BLOCKONLY;
        }

        public Action getAction() {
            return this.action;
        }

        public Object getTarget() {
            return this.target;
        }
    }

    public static enum Action {
        DEFAULT,
        IGNORE,
        WARN,
        FAIL,
        REMAP,
        BLOCKONLY;

    }
}

