/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.AttributeKey;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import org.apache.logging.log4j.Level;

@ChannelHandler.Sharable
public abstract class FMLIndexedMessageToMessageCodec<A>
extends MessageToMessageCodec<FMLProxyPacket, A> {
    private TByteObjectHashMap<Class<? extends A>> discriminators = new TByteObjectHashMap();
    private TObjectByteHashMap<Class<? extends A>> types = new TObjectByteHashMap();
    public static final AttributeKey<ThreadLocal<WeakReference<FMLProxyPacket>>> INBOUNDPACKETTRACKER = AttributeKey.valueOf((String)"fml:inboundpacket");

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.attr(INBOUNDPACKETTRACKER).set(new ThreadLocal());
    }

    public FMLIndexedMessageToMessageCodec<A> addDiscriminator(int discriminator, Class<? extends A> type) {
        this.discriminators.put((byte)discriminator, type);
        this.types.put(type, (byte)discriminator);
        return this;
    }

    public abstract void encodeInto(ChannelHandlerContext var1, A var2, ByteBuf var3) throws Exception;

    protected final void encode(ChannelHandlerContext ctx, A msg, List<Object> out) throws Exception {
        FMLProxyPacket old;
        eq buffer = new eq(Unpooled.buffer());
        byte discriminator = this.types.get(msg.getClass());
        buffer.writeByte((int)discriminator);
        this.encodeInto(ctx, msg, (ByteBuf)buffer);
        FMLProxyPacket proxy = new FMLProxyPacket(buffer, (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        WeakReference ref = (WeakReference)((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).get();
        FMLProxyPacket fMLProxyPacket = old = ref == null ? null : (FMLProxyPacket)ref.get();
        if (old != null) {
            proxy.setDispatcher(old.getDispatcher());
        }
        out.add(proxy);
    }

    public abstract void decodeInto(ChannelHandlerContext var1, ByteBuf var2, A var3);

    protected final void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        byte discriminator;
        Class clazz;
        this.testMessageValidity(msg);
        ByteBuf payload = msg.payload().duplicate();
        if (payload.readableBytes() < 1) {
            FMLLog.log(Level.ERROR, "The FMLIndexedCodec has received an empty buffer on channel %s, likely a result of a LAN server issue. Pipeline parts : %s", ctx.channel().attr(NetworkRegistry.FML_CHANNEL), ctx.pipeline().toString());
        }
        if ((clazz = (Class)this.discriminators.get(discriminator = payload.readByte())) == null) {
            throw new NullPointerException("Undefined message for discriminator " + discriminator + " in channel " + msg.channel());
        }
        Object newMsg = clazz.newInstance();
        ((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).set(new WeakReference<FMLProxyPacket>(msg));
        this.decodeInto(ctx, payload.slice(), newMsg);
        out.add(newMsg);
    }

    protected void testMessageValidity(FMLProxyPacket msg) {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log(Level.ERROR, cause, "FMLIndexedMessageCodec exception caught", new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

