/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.client.settings.KeyModifier;

public class KeyBindingMap {
    private static final EnumMap<KeyModifier, oo<Collection<bep>>> map = new EnumMap(KeyModifier.class);

    @Nullable
    public bep lookupActive(int keyCode) {
        bep binding;
        KeyModifier activeModifier = KeyModifier.getActiveModifier();
        if (!activeModifier.matches(keyCode) && (binding = this.getBinding(keyCode, activeModifier)) != null) {
            return binding;
        }
        return this.getBinding(keyCode, KeyModifier.NONE);
    }

    @Nullable
    private bep getBinding(int keyCode, KeyModifier keyModifier) {
        Collection bindings = (Collection)map.get((Object)keyModifier).a(keyCode);
        if (bindings != null) {
            for (bep binding : bindings) {
                if (!binding.isActiveAndMatches(keyCode)) continue;
                return binding;
            }
        }
        return null;
    }

    public List<bep> lookupAll(int keyCode) {
        ArrayList<bep> matchingBindings = new ArrayList<bep>();
        for (oo<Collection<bep>> bindingsMap : map.values()) {
            Collection bindings = (Collection)bindingsMap.a(keyCode);
            if (bindings == null) continue;
            matchingBindings.addAll(bindings);
        }
        return matchingBindings;
    }

    public void addKey(int keyCode, bep keyBinding) {
        KeyModifier keyModifier = keyBinding.getKeyModifier();
        oo<Collection<bep>> bindingsMap = map.get((Object)keyModifier);
        ArrayList<bep> bindingsForKey = (ArrayList<bep>)bindingsMap.a(keyCode);
        if (bindingsForKey == null) {
            bindingsForKey = new ArrayList<bep>();
            bindingsMap.a(keyCode, bindingsForKey);
        }
        bindingsForKey.add(keyBinding);
    }

    public void removeKey(bep keyBinding) {
        KeyModifier keyModifier = keyBinding.getKeyModifier();
        int keyCode = keyBinding.j();
        oo<Collection<bep>> bindingsMap = map.get((Object)keyModifier);
        Collection bindingsForKey = (Collection)bindingsMap.a(keyCode);
        if (bindingsForKey != null) {
            bindingsForKey.remove(keyBinding);
            if (bindingsForKey.isEmpty()) {
                bindingsMap.d(keyCode);
            }
        }
    }

    public void clearMap() {
        for (oo<Collection<bep>> bindings : map.values()) {
            bindings.c();
        }
    }

    static {
        for (KeyModifier modifier : KeyModifier.values()) {
            map.put(modifier, (oo<Collection<bep>>)new oo());
        }
    }
}

