/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerInteractEvent
extends PlayerEvent {
    private final ri hand;
    private final co pos;
    @Nullable
    private final cv face;
    private rk cancellationResult = rk.b;

    private PlayerInteractEvent(aay player, ri hand, co pos, @Nullable cv face) {
        super((aay)Preconditions.checkNotNull((Object)player, (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (ri)Preconditions.checkNotNull((Object)hand, (Object)"Null hand in PlayerInteractEvent!");
        this.pos = (co)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    @Nonnull
    public ri getHand() {
        return this.hand;
    }

    @Nonnull
    public afj getItemStack() {
        return this.getEntityPlayer().b(this.hand);
    }

    @Nonnull
    public co getPos() {
        return this.pos;
    }

    @Nullable
    public cv getFace() {
        return this.face;
    }

    public ajs getWorld() {
        return this.getEntityPlayer().e();
    }

    public Side getSide() {
        return this.getWorld().E ? Side.CLIENT : Side.SERVER;
    }

    public rk getCancellationResult() {
        return this.cancellationResult;
    }

    public void setCancellationResult(rk result) {
        this.cancellationResult = result;
    }

    public static class LeftClickEmpty
    extends PlayerInteractEvent {
        public LeftClickEmpty(aay player) {
            super(player, ri.a, new co((sn)player), null);
        }

        @Deprecated
        public LeftClickEmpty(aay player, @Nonnull afj stack) {
            this(player);
        }
    }

    @Cancelable
    public static class LeftClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final bdw hitVec;

        public LeftClickBlock(aay player, co pos, cv face, bdw hitVec) {
            super(player, ri.a, pos, face);
            this.hitVec = hitVec;
        }

        public bdw getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    public static class RightClickEmpty
    extends PlayerInteractEvent {
        public RightClickEmpty(aay player, ri hand) {
            super(player, hand, new co((sn)player), null);
        }
    }

    @Cancelable
    public static class RightClickItem
    extends PlayerInteractEvent {
        public RightClickItem(aay player, ri hand) {
            super(player, hand, new co((sn)player), null);
        }
    }

    @Cancelable
    public static class RightClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final bdw hitVec;

        public RightClickBlock(aay player, ri hand, co pos, cv face, bdw hitVec) {
            super(player, hand, pos, face);
            this.hitVec = hitVec;
        }

        public bdw getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    @Cancelable
    public static class EntityInteract
    extends PlayerInteractEvent {
        private final sn target;

        public EntityInteract(aay player, ri hand, sn target) {
            super(player, hand, new co(target), null);
            this.target = target;
        }

        public sn getTarget() {
            return this.target;
        }
    }

    @Cancelable
    public static class EntityInteractSpecific
    extends PlayerInteractEvent {
        private final bdw localPos;
        private final sn target;

        public EntityInteractSpecific(aay player, ri hand, sn target, bdw localPos) {
            super(player, hand, new co(target), null);
            this.localPos = localPos;
            this.target = target;
        }

        public bdw getLocalPos() {
            return this.localPos;
        }

        public sn getTarget() {
            return this.target;
        }
    }
}

