/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class UniversalBucket
extends afh {
    private final int capacity;
    @Nonnull
    private final afj empty;
    private final boolean nbtSensitive;

    public UniversalBucket() {
        this(1000, new afj(afl.az), false);
    }

    public UniversalBucket(int capacity, @Nonnull afj empty, boolean nbtSensitive) {
        this.capacity = capacity;
        this.empty = empty;
        this.nbtSensitive = nbtSensitive;
        this.d(1);
        this.a(aej.f);
        amw.c.a((Object)this, (Object)DispenseFluidContainer.getInstance());
    }

    public boolean hasContainerItem(@Nonnull afj stack) {
        return !this.getEmpty().b();
    }

    @Nonnull
    public afj getContainerItem(@Nonnull afj itemStack) {
        if (!this.getEmpty().b()) {
            return this.getEmpty().l();
        }
        return super.getContainerItem(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void a(@Nonnull afh itemIn, @Nullable aej tab, @Nonnull dd<afj> subItems) {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            FluidStack fs;
            afj stack;
            FluidBucketWrapper fluidHandler;
            if (fluid == FluidRegistry.WATER || fluid == FluidRegistry.LAVA || fluid.getName().equals("milk") || (fluidHandler = new FluidBucketWrapper(stack = new afj((afh)this))).fill(fs = new FluidStack(fluid, this.getCapacity()), true) != fs.amount) continue;
            afj filled = fluidHandler.getContainer();
            subItems.add((Object)filled);
        }
    }

    @Nonnull
    public String b(@Nonnull afj stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            if (!this.getEmpty().b()) {
                return this.getEmpty().r();
            }
            return super.b(stack);
        }
        String unloc = this.j(stack);
        if (dp.c((String)(unloc + "." + fluidStack.getFluid().getName()))) {
            return dp.a((String)(unloc + "." + fluidStack.getFluid().getName()));
        }
        return dp.a((String)(unloc + ".name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    @Nonnull
    public rl<afj> a(@Nonnull ajs world, @Nonnull aay player, @Nonnull ri hand) {
        FluidActionResult result;
        co targetPos;
        afj itemstack = player.b(hand);
        FluidStack fluidStack = this.getFluid(itemstack);
        if (fluidStack == null) {
            return rl.newResult((rk)rk.b, (Object)itemstack);
        }
        bdu mop = this.a(world, player, false);
        if (mop == null || mop.a != bdu.a.b) {
            return rl.newResult((rk)rk.b, (Object)itemstack);
        }
        co clickPos = mop.a();
        if (world.a(player, clickPos) && player.a(targetPos = clickPos.a(mop.b), mop.b, itemstack) && (result = FluidUtil.tryPlaceFluid(player, world, targetPos, itemstack, fluidStack)).isSuccess() && !player.bK.d) {
            afj emptyStack;
            player.b(oa.b((afh)this));
            itemstack.g(1);
            afj drained = result.getResult();
            afj afj2 = emptyStack = !drained.b() ? drained.l() : new afj((afh)this);
            if (itemstack.b()) {
                return rl.newResult((rk)rk.a, (Object)emptyStack);
            }
            ItemHandlerHelper.giveItemToPlayer(player, emptyStack);
            return rl.newResult((rk)rk.a, (Object)itemstack);
        }
        return rl.newResult((rk)rk.c, (Object)itemstack);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFillBucket(FillBucketEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        afj emptyBucket = event.getEmptyBucket();
        if (emptyBucket.b() || !emptyBucket.a(this.getEmpty()) || this.isNbtSensitive() && afj.a((afj)emptyBucket, (afj)this.getEmpty())) {
            return;
        }
        bdu target = event.getTarget();
        if (target == null || target.a != bdu.a.b) {
            return;
        }
        ajs world = event.getWorld();
        co pos = target.a();
        afj singleBucket = emptyBucket.l();
        singleBucket.e(1);
        FluidActionResult filledResult = FluidUtil.tryPickUpFluid(singleBucket, event.getEntityPlayer(), world, pos, target.b);
        if (filledResult.isSuccess()) {
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(filledResult.getResult());
        } else {
            event.setCanceled(true);
        }
    }

    @Nonnull
    public static afj getFilledBucket(@Nonnull UniversalBucket item, Fluid fluid) {
        afj bucket = new afj((afh)item);
        if (FluidRegistry.getBucketFluids().contains(fluid)) {
            du tag = new du();
            FluidStack fluidStack = new FluidStack(fluid, item.getCapacity());
            fluidStack.writeToNBT(tag);
            bucket.b(tag);
        } else {
            if (fluid == FluidRegistry.WATER) {
                return new afj(afl.aA);
            }
            if (fluid == FluidRegistry.LAVA) {
                return new afj(afl.aB);
            }
        }
        return bucket;
    }

    @Nullable
    public FluidStack getFluid(@Nonnull afj container) {
        return FluidStack.loadFluidStackFromNBT(container.p());
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Nonnull
    public afj getEmpty() {
        return this.empty;
    }

    public boolean isNbtSensitive() {
        return this.nbtSensitive;
    }

    public ICapabilityProvider initCapabilities(@Nonnull afj stack, du nbt) {
        return new FluidBucketWrapper(stack);
    }
}

