/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;

public class ModCandidate {
    private File classPathRoot;
    private File modContainer;
    private ContainerType sourceType;
    private boolean classpath;
    private List<String> baseModTypes = Lists.newArrayList();
    private boolean isMinecraft;
    private List<ASMModParser> baseModCandidateTypes = Lists.newArrayListWithCapacity((int)1);
    private Set<String> foundClasses = Sets.newHashSet();
    private List<ModContainer> mods;
    private List<String> packages = Lists.newArrayList();
    private ASMDataTable table;

    public ModCandidate(File classPathRoot, File modContainer, ContainerType sourceType) {
        this(classPathRoot, modContainer, sourceType, false, false);
    }

    public ModCandidate(File classPathRoot, File modContainer, ContainerType sourceType, boolean isMinecraft, boolean classpath) {
        this.classPathRoot = classPathRoot;
        this.modContainer = modContainer;
        this.sourceType = sourceType;
        this.isMinecraft = isMinecraft;
        this.classpath = classpath;
    }

    public File getClassPathRoot() {
        return this.classPathRoot;
    }

    public File getModContainer() {
        return this.modContainer;
    }

    public ContainerType getSourceType() {
        return this.sourceType;
    }

    public List<ModContainer> explore(ASMDataTable table) {
        this.table = table;
        this.mods = this.sourceType.findMods(this, table);
        if (!this.baseModCandidateTypes.isEmpty()) {
            FMLLog.log.info("Attempting to reparse the mod container {}", new Object[]{this.getModContainer().getName()});
            this.mods = this.sourceType.findMods(this, table);
        }
        return this.mods;
    }

    public void addClassEntry(String name) {
        String className = name.substring(0, name.lastIndexOf(46));
        this.foundClasses.add(className);
        className = className.replace('/', '.');
        int pkgIdx = className.lastIndexOf(46);
        if (pkgIdx > -1) {
            String pkg = className.substring(0, pkgIdx);
            this.packages.add(pkg);
            this.table.registerPackage(this, pkg);
        }
    }

    public boolean isClasspath() {
        return this.classpath;
    }

    public void rememberBaseModType(String className) {
        this.baseModTypes.add(className);
    }

    public List<String> getRememberedBaseMods() {
        return this.baseModTypes;
    }

    public boolean isMinecraftJar() {
        return this.isMinecraft;
    }

    public void rememberModCandidateType(ASMModParser modParser) {
        this.baseModCandidateTypes.add(modParser);
    }

    public Set<String> getClassList() {
        return this.foundClasses;
    }

    public List<ModContainer> getContainedMods() {
        return this.mods;
    }

    public List<String> getContainedPackages() {
        return this.packages;
    }
}

