/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkModHolder {
    private static int assignedIds = 1;
    private int localId;
    private int networkId;
    private ModContainer container;
    private Method checkHandler;
    private VersionRange acceptableRange;
    private NetworkChecker checker;
    private boolean acceptsVanillaClient;
    private boolean acceptsVanillaServer;

    public NetworkModHolder(ModContainer container) {
        this.container = container;
        this.networkId = this.localId = assignedIds++;
    }

    public NetworkModHolder(ModContainer container, NetworkChecker checker) {
        this(container);
        this.checker = (NetworkChecker)Preconditions.checkNotNull((Object)checker);
        FMLLog.log.debug("The mod {} is using a custom checker {}", new Object[]{container.getModId(), checker.getClass().getName()});
    }

    public NetworkModHolder(ModContainer container, Class<?> modClass, @Nullable String acceptableVersionRange, ASMDataTable table) {
        this(container);
        SetMultimap<String, ASMDataTable.ASMData> annotationTable = table.getAnnotationsFor(container);
        Set versionCheckHandlers = annotationTable != null ? annotationTable.get((Object)NetworkCheckHandler.class.getName()) : ImmutableSet.of();
        String networkCheckHandlerMethod = null;
        Method[] methodArray = versionCheckHandlers.iterator();
        while (methodArray.hasNext()) {
            ASMDataTable.ASMData vch = (ASMDataTable.ASMData)methodArray.next();
            if (!vch.getClassName().equals(modClass.getName())) continue;
            networkCheckHandlerMethod = vch.getObjectName();
            networkCheckHandlerMethod = networkCheckHandlerMethod.substring(0, networkCheckHandlerMethod.indexOf(40));
            break;
        }
        if (versionCheckHandlers.isEmpty()) {
            for (Method m2 : modClass.getMethods()) {
                if (!m2.isAnnotationPresent(NetworkCheckHandler.class)) continue;
                if (m2.getParameterTypes().length == 2 && m2.getParameterTypes()[0].equals(Map.class) && m2.getParameterTypes()[1].equals(Side.class)) {
                    this.checkHandler = m2;
                    break;
                }
                FMLLog.log.fatal("Found unexpected method signature for annotation NetworkCheckHandler");
            }
        }
        if (networkCheckHandlerMethod != null) {
            try {
                Method checkHandlerMethod = modClass.getDeclaredMethod(networkCheckHandlerMethod, Map.class, Side.class);
                if (checkHandlerMethod.isAnnotationPresent(NetworkCheckHandler.class)) {
                    this.checkHandler = checkHandlerMethod;
                }
            }
            catch (Exception e2) {
                FMLLog.log.warn("The declared version check handler method {} on network mod id {} is not accessible", new Object[]{networkCheckHandlerMethod, container.getModId(), e2});
            }
        }
        if (this.checkHandler != null) {
            this.checker = new MethodNetworkChecker();
        } else if (!Strings.isNullOrEmpty((String)acceptableVersionRange) && acceptableVersionRange.equals("*")) {
            this.checker = new IgnoredChecker();
        } else {
            try {
                this.acceptableRange = VersionRange.createFromVersionSpec(acceptableVersionRange);
            }
            catch (InvalidVersionSpecificationException e3) {
                FMLLog.log.warn("Invalid bounded range {} specified for network mod id {}", new Object[]{acceptableVersionRange, container.getModId(), e3});
            }
            this.checker = new DefaultNetworkChecker();
        }
        FMLLog.log.trace("Mod {} is using network checker : {}", new Object[]{container.getModId(), this.checker});
        FMLLog.log.trace("Testing mod {} to verify it accepts its own version in a remote connection", new Object[]{container.getModId()});
        boolean acceptsSelf = this.acceptVersion(container.getVersion());
        if (!acceptsSelf) {
            FMLLog.log.fatal("The mod {} appears to reject its own version number ({}) in its version handling. This is likely a severe bug in the mod!", new Object[]{container.getModId(), container.getVersion()});
        } else {
            FMLLog.log.trace("The mod {} accepts its own version ({})", new Object[]{container.getModId(), container.getVersion()});
        }
    }

    public boolean acceptVersion(String version) {
        if (this.acceptableRange != null) {
            return this.acceptableRange.containsVersion(new DefaultArtifactVersion(version));
        }
        return this.container.getVersion().equals(version);
    }

    public boolean check(Map<String, String> data, Side side) {
        return this.checker.check(data, side);
    }

    public int getLocalId() {
        return this.localId;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public ModContainer getContainer() {
        return this.container;
    }

    public void setNetworkId(int value) {
        this.networkId = value;
    }

    public void testVanillaAcceptance() {
        this.acceptsVanillaClient = this.check((Map<String, String>)ImmutableMap.of(), Side.CLIENT);
        this.acceptsVanillaServer = this.check((Map<String, String>)ImmutableMap.of(), Side.SERVER);
    }

    public boolean acceptsVanilla(Side from) {
        return from == Side.CLIENT ? this.acceptsVanillaClient : this.acceptsVanillaServer;
    }

    private class MethodNetworkChecker
    extends NetworkChecker {
        private MethodNetworkChecker() {
        }

        @Override
        public boolean check(Map<String, String> remoteVersions, Side side) {
            try {
                return (Boolean)NetworkModHolder.this.checkHandler.invoke(NetworkModHolder.this.container.getMod(), new Object[]{remoteVersions, side});
            }
            catch (Exception e2) {
                FMLLog.log.error("Error occurred invoking NetworkCheckHandler {} at {}", new Object[]{NetworkModHolder.this.container, e2});
                return false;
            }
        }

        public String toString() {
            return String.format("Invoking method %s", NetworkModHolder.this.checkHandler.getName());
        }
    }

    private class DefaultNetworkChecker
    extends NetworkChecker {
        private DefaultNetworkChecker() {
        }

        @Override
        public boolean check(Map<String, String> remoteVersions, Side side) {
            return remoteVersions.containsKey(NetworkModHolder.this.container.getModId()) ? NetworkModHolder.this.acceptVersion(remoteVersions.get(NetworkModHolder.this.container.getModId())) : side == Side.SERVER;
        }

        public String toString() {
            return NetworkModHolder.this.acceptableRange != null ? String.format("Accepting range %s", NetworkModHolder.this.acceptableRange) : String.format("Accepting version %s", NetworkModHolder.this.container.getVersion());
        }
    }

    private class IgnoredChecker
    extends NetworkChecker {
        private IgnoredChecker() {
        }

        @Override
        public boolean check(Map<String, String> remoteVersions, Side side) {
            return true;
        }

        public String toString() {
            return "No network checking performed";
        }
    }

    public abstract class NetworkChecker {
        public abstract boolean check(Map<String, String> var1, Side var2);
    }
}

