/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery.asm;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import org.objectweb.asm.Type;

public class ModAnnotation {
    ASMModParser.AnnotationType type;
    Type asmType;
    String member;
    Map<String, Object> values = Maps.newHashMap();
    private ArrayList<Object> arrayList;
    private String arrayName;

    public ModAnnotation(ASMModParser.AnnotationType type, Type asmType, String member) {
        this.type = type;
        this.asmType = asmType;
        this.member = member;
    }

    public ModAnnotation(ASMModParser.AnnotationType type, Type asmType, ModAnnotation parent) {
        this.type = type;
        this.asmType = asmType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Annotation").add("type", (Object)this.type).add("name", (Object)this.asmType.getClassName()).add("member", (Object)this.member).add("values", this.values).toString();
    }

    public ASMModParser.AnnotationType getType() {
        return this.type;
    }

    public Type getASMType() {
        return this.asmType;
    }

    public String getMember() {
        return this.member;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void addArray(String name) {
        this.arrayList = Lists.newArrayList();
        this.arrayName = name;
    }

    public void addProperty(String key, Object value) {
        if (this.arrayList != null) {
            this.arrayList.add(value);
        } else {
            this.values.put(key, value);
        }
    }

    public void addEnumProperty(String key, String enumName, String value) {
        this.addProperty(key, new EnumHolder(enumName, value));
    }

    public void endArray() {
        this.values.put(this.arrayName, this.arrayList);
        this.arrayList = null;
    }

    public ModAnnotation addChildAnnotation(String name, String desc) {
        ModAnnotation child = new ModAnnotation(ASMModParser.AnnotationType.SUBTYPE, Type.getType((String)desc), this);
        this.addProperty(name, child.getValues());
        return child;
    }

    public static class EnumHolder {
        private final String desc;
        private final String value;

        public EnumHolder(String desc, String value) {
            this.desc = desc;
            this.value = value;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getValue() {
            return this.value;
        }
    }
}

