/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraftforge.common.model.TRSRTransformation;

public class QuadTransformer {
    private final VertexFormat format;
    private final int positionOffset;
    private final int normalOffset;
    private final TRSRTransformation transform;

    public QuadTransformer(VertexFormat format, TRSRTransformation transform) {
        this.format = format;
        this.positionOffset = QuadTransformer.findPositionOffset(format);
        this.normalOffset = QuadTransformer.findNormalOffset(format);
        this.transform = transform;
    }

    private void processVertices(int[] inData, int[] outData) {
        int offset;
        int i;
        int stride = this.format.func_177338_f();
        int count = inData.length * 4 / stride;
        for (i = 0; i < count; ++i) {
            offset = this.positionOffset + i * stride;
            float x = Float.intBitsToFloat(QuadTransformer.getAtByteOffset(inData, offset));
            float y = Float.intBitsToFloat(QuadTransformer.getAtByteOffset(inData, offset + 4));
            float z = Float.intBitsToFloat(QuadTransformer.getAtByteOffset(inData, offset + 8));
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            this.transform.transformPosition(pos);
            if (pos.w != 1.0f) {
                pos.scale(1.0f / pos.w);
            }
            QuadTransformer.putAtByteOffset(outData, offset, Float.floatToRawIntBits(pos.getX()));
            QuadTransformer.putAtByteOffset(outData, offset + 4, Float.floatToRawIntBits(pos.getY()));
            QuadTransformer.putAtByteOffset(outData, offset + 8, Float.floatToRawIntBits(pos.getZ()));
        }
        if (this.normalOffset >= 0) {
            for (i = 0; i < count; ++i) {
                offset = this.normalOffset + i * stride;
                int normalIn = QuadTransformer.getAtByteOffset(inData, offset);
                if (normalIn == 0) continue;
                float x = (float)(normalIn >> 24 & 0xFF) / 255.0f;
                float y = (float)(normalIn << 8 >> 24 & 0xFF) / 255.0f;
                float z = (float)(normalIn << 16 >> 24 & 0xFF) / 255.0f;
                Vector3f pos = new Vector3f(x, y, z);
                this.transform.transformNormal(pos);
                pos.normalize();
                int normalOut = ((int)((double)x / 255.0) & 0xFF) << 24 | ((int)((double)y / 255.0) & 0xFF) << 16 | ((int)((double)z / 255.0) & 0xFF) << 8 | normalIn & 0xFF;
                QuadTransformer.putAtByteOffset(outData, offset, normalOut);
            }
        }
    }

    private static int getAtByteOffset(int[] inData, int offset) {
        int index = offset / 4;
        int lsb = inData[index];
        int shift = offset % 4 * 8;
        if (shift == 0) {
            return inData[index];
        }
        int msb = inData[index + 1];
        return lsb >>> shift | msb << 32 - shift;
    }

    private static void putAtByteOffset(int[] outData, int offset, int value) {
        int index = offset / 4;
        int shift = offset % 4 * 8;
        if (shift == 0) {
            outData[index] = value;
        }
        int lsbMask = -1 >>> 32 - shift;
        int msbMask = -1 << shift;
        outData[index] = outData[index] & lsbMask | value << shift;
        outData[index + 1] = outData[index + 1] & msbMask | value >>> 32 - shift;
    }

    private static int findPositionOffset(VertexFormat fmt) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < fmt.func_177345_h(); ++index) {
            VertexFormatElement el = fmt.func_177348_c(index);
            if (el.func_177375_c() != VertexFormatElement.Usage.POSITION) continue;
            element = el;
            break;
        }
        if (index == fmt.func_177345_h() || element == null) {
            throw new RuntimeException("Expected vertex format to have a POSITION attribute");
        }
        if (element.func_177367_b() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("Expected POSITION attribute to have data type FLOAT");
        }
        if (element.func_177368_f() < 3) {
            throw new RuntimeException("Expected POSITION attribute to have at least 3 dimensions");
        }
        return fmt.func_181720_d(index);
    }

    private static int findNormalOffset(VertexFormat fmt) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < fmt.func_177345_h(); ++index) {
            VertexFormatElement el = fmt.func_177348_c(index);
            if (el.func_177375_c() != VertexFormatElement.Usage.NORMAL) continue;
            element = el;
            break;
        }
        if (index == fmt.func_177345_h() || element == null) {
            return -1;
        }
        if (element.func_177367_b() != VertexFormatElement.Type.BYTE) {
            throw new RuntimeException("Expected NORMAL attribute to have data type BYTE");
        }
        if (element.func_177368_f() < 3) {
            throw new RuntimeException("Expected NORMAL attribute to have at least 3 dimensions");
        }
        return fmt.func_181720_d(index);
    }

    public BakedQuad processOne(BakedQuad input) {
        int[] inData = input.func_178209_a();
        int[] outData = Arrays.copyOf(inData, inData.length);
        this.processVertices(inData, outData);
        return new BakedQuad(outData, input.func_178211_c(), input.func_178210_d(), input.func_187508_a(), input.shouldApplyDiffuseLighting(), this.format);
    }

    public BakedQuad processOneInPlace(BakedQuad input) {
        int[] data = input.func_178209_a();
        this.processVertices(data, data);
        return input;
    }

    public List<BakedQuad> processMany(List<BakedQuad> inputs) {
        if (inputs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList outputs = Lists.newArrayList();
        for (BakedQuad input : inputs) {
            int[] inData = input.func_178209_a();
            int[] outData = Arrays.copyOf(inData, inData.length);
            this.processVertices(inData, outData);
            outputs.add(new BakedQuad(outData, input.func_178211_c(), input.func_178210_d(), input.func_187508_a(), input.shouldApplyDiffuseLighting(), this.format));
        }
        return outputs;
    }

    public void processManyInPlace(List<BakedQuad> inputs) {
        if (inputs.size() == 0) {
            return;
        }
        for (BakedQuad input : inputs) {
            int[] data = input.func_178209_a();
            this.processVertices(data, data);
        }
    }
}

