/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.geometry;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.geometry.ISimpleModelGeometry;

public interface IMultipartModelGeometry<T extends IMultipartModelGeometry<T>>
extends ISimpleModelGeometry<T> {
    @Override
    public Collection<? extends IModelGeometryPart> getParts();

    @Override
    public Optional<? extends IModelGeometryPart> getPart(String var1);

    @Override
    default public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        this.getParts().stream().filter(part -> owner.getPartVisibility((IModelGeometryPart)part)).forEach(part -> part.addQuads(owner, modelBuilder, bakery, spriteGetter, sprite, format));
    }

    @Override
    default public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        HashSet combined = Sets.newHashSet();
        for (IModelGeometryPart part : this.getParts()) {
            combined.addAll(part.getTextureDependencies(owner, modelGetter, missingTextureErrors));
        }
        return combined;
    }
}

