/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.obj.LineReader;
import net.minecraftforge.client.model.obj.MaterialLibrary2;
import net.minecraftforge.client.model.obj.OBJModel2;

public class OBJLoader2
implements IModelLoader<OBJModel2> {
    public static OBJLoader2 INSTANCE = new OBJLoader2();
    private final Map<OBJModel2.ModelSettings, OBJModel2> modelCache = Maps.newHashMap();
    private final Map<ResourceLocation, MaterialLibrary2> materialCache = Maps.newHashMap();
    private IResourceManager manager = Minecraft.func_71410_x().func_195551_G();

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.manager = resourceManager;
    }

    @Override
    public OBJModel2 read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("model")) {
            throw new RuntimeException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocation = modelContents.get("model").getAsString();
        boolean detectCullableFaces = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"detectCullableFaces", (boolean)true);
        boolean diffuseLighting = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"diffuseLighting", (boolean)false);
        boolean flipV = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"flip-v", (boolean)false);
        boolean ambientToFullbright = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"ambientToFullbright", (boolean)true);
        String materialLibraryOverrideLocation = modelContents.has("materialLibraryOverride") ? JSONUtils.func_151200_h((JsonObject)modelContents, (String)"materialLibraryOverride") : null;
        return this.loadModel(new OBJModel2.ModelSettings(new ResourceLocation(modelLocation), detectCullableFaces, diffuseLighting, flipV, ambientToFullbright, materialLibraryOverrideLocation));
    }

    public OBJModel2 loadModel(OBJModel2.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            IResource resource;
            try {
                resource = this.manager.func_199002_a(settings.modelLocation);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not find OBJ model", e);
            }
            try (LineReader rdr = new LineReader(resource);){
                OBJModel2 oBJModel2 = new OBJModel2(rdr, settings);
                return oBJModel2;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read OBJ model", e);
            }
        });
    }

    public MaterialLibrary2 loadMaterialLibrary(ResourceLocation materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            IResource resource;
            try {
                resource = this.manager.func_199002_a(location);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not find OBJ material library", e);
            }
            try (LineReader rdr = new LineReader(resource);){
                MaterialLibrary2 materialLibrary2 = new MaterialLibrary2(rdr);
                return materialLibrary2;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read OBJ material library", e);
            }
        });
    }
}

