/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import joptsimple.internal.Strings;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoaderRegistry2;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.geometry.IMultipartModelGeometry;
import net.minecraftforge.client.model.obj.LineReader;
import net.minecraftforge.client.model.obj.MaterialLibrary2;
import net.minecraftforge.client.model.obj.OBJLoader2;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class OBJModel2
implements IMultipartModelGeometry<OBJModel2> {
    private static Vector2f[] DEFAULT_COORDS = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f), new Vector2f(1.0f, 0.0f)};
    private final Map<String, ModelGroup> parts = Maps.newHashMap();
    private final List<Vector3f> positions = Lists.newArrayList();
    private final List<Vector2f> texCoords = Lists.newArrayList();
    private final List<Vector3f> normals = Lists.newArrayList();
    private final List<Vector4f> colors = Lists.newArrayList();
    public final boolean detectCullableFaces;
    public final boolean diffuseLighting;
    public final boolean flipV;
    public final boolean ambientToFullbright;
    public final ResourceLocation modelLocation;
    @Nullable
    public final String materialLibraryOverrideLocation;

    OBJModel2(LineReader reader, ModelSettings settings) throws IOException {
        String[] line;
        this.modelLocation = settings.modelLocation;
        this.detectCullableFaces = settings.detectCullableFaces;
        this.diffuseLighting = settings.diffuseLighting;
        this.flipV = settings.flipV;
        this.ambientToFullbright = settings.ambientToFullbright;
        this.materialLibraryOverrideLocation = settings.materialLibraryOverrideLocation;
        String modelDomain = this.modelLocation.func_110624_b();
        String modelPath = this.modelLocation.func_110623_a();
        int lastSlash = modelPath.lastIndexOf(47);
        modelPath = lastSlash >= 0 ? modelPath.substring(0, lastSlash + 1) : "";
        MaterialLibrary2 mtllib = MaterialLibrary2.EMPTY;
        MaterialLibrary2.Material currentMat = null;
        String currentSmoothingGroup = null;
        ModelGroup currentGroup = null;
        ModelObject currentObject = null;
        ModelMesh currentMesh = null;
        boolean objAboveGroup = false;
        if (this.materialLibraryOverrideLocation != null) {
            String lib = this.materialLibraryOverrideLocation;
            mtllib = lib.contains(":") ? OBJLoader2.INSTANCE.loadMaterialLibrary(new ResourceLocation(lib)) : OBJLoader2.INSTANCE.loadMaterialLibrary(new ResourceLocation(modelDomain, modelPath + lib));
        }
        while ((line = reader.readAndSplitLine(true)) != null) {
            switch (line[0]) {
                case "mtllib": {
                    if (this.materialLibraryOverrideLocation != null) break;
                    String lib = line[1];
                    if (lib.contains(":")) {
                        mtllib = OBJLoader2.INSTANCE.loadMaterialLibrary(new ResourceLocation(lib));
                        break;
                    }
                    mtllib = OBJLoader2.INSTANCE.loadMaterialLibrary(new ResourceLocation(modelDomain, modelPath + lib));
                    break;
                }
                case "usemtl": {
                    String mat = Strings.join((String[])Arrays.copyOfRange(line, 1, line.length), (String)" ");
                    MaterialLibrary2.Material newMat = mtllib.getMaterial(mat);
                    if (Objects.equals(newMat, currentMat)) break;
                    currentMat = newMat;
                    if (currentMesh != null && currentMesh.mat == null && currentMesh.faces.size() == 0) {
                        currentMesh.mat = currentMat;
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "v": {
                    this.positions.add(OBJModel2.parseVector4To3(line));
                    break;
                }
                case "vt": {
                    this.texCoords.add(OBJModel2.parseVector2(line));
                    break;
                }
                case "vn": {
                    this.normals.add(OBJModel2.parseVector3(line));
                    break;
                }
                case "vc": {
                    this.colors.add(OBJModel2.parseVector4(line));
                    break;
                }
                case "f": {
                    if (currentMesh == null) {
                        currentMesh = new ModelMesh(currentMat, currentSmoothingGroup);
                        if (currentObject != null) {
                            currentObject.meshes.add(currentMesh);
                        } else {
                            if (currentGroup == null) {
                                currentGroup = new ModelGroup("");
                                this.parts.put("", currentGroup);
                            }
                            currentGroup.meshes.add(currentMesh);
                        }
                    }
                    int[][] vertices = new int[line.length - 1][];
                    for (int i = 0; i < vertices.length; ++i) {
                        String vertexData = line[i + 1];
                        String[] vertexParts = vertexData.split("/");
                        int[] vertex = Arrays.stream(vertexParts).mapToInt(num -> Strings.isNullOrEmpty((String)num) ? 0 : Integer.parseInt(num)).toArray();
                        vertex[0] = vertex[0] < 0 ? this.positions.size() + vertex[0] : vertex[0] - 1;
                        if (vertex.length > 1) {
                            vertex[1] = vertex[1] < 0 ? this.texCoords.size() + vertex[1] : vertex[1] - 1;
                            if (vertex.length > 2) {
                                vertex[2] = vertex[2] < 0 ? this.normals.size() + vertex[2] : vertex[2] - 1;
                                if (vertex.length > 3) {
                                    vertex[3] = vertex[3] < 0 ? this.colors.size() + vertex[3] : vertex[3] - 1;
                                }
                            }
                        }
                        vertices[i] = vertex;
                    }
                    currentMesh.faces.add(vertices);
                    break;
                }
                case "s": {
                    String smoothingGroup;
                    String string = smoothingGroup = "off".equals(line[1]) ? null : line[1];
                    if (Objects.equals(currentSmoothingGroup, smoothingGroup)) break;
                    currentSmoothingGroup = smoothingGroup;
                    if (currentMesh != null && currentMesh.smoothingGroup == null && currentMesh.faces.size() == 0) {
                        currentMesh.smoothingGroup = currentSmoothingGroup;
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "g": {
                    String name = line[1];
                    if (objAboveGroup) {
                        currentObject = new ModelObject(currentGroup.name() + "/" + name);
                        currentGroup.parts.put(name, currentObject);
                    } else {
                        currentGroup = new ModelGroup(name);
                        this.parts.put(name, currentGroup);
                        currentObject = null;
                    }
                    currentMesh = null;
                    break;
                }
                case "o": {
                    String name = line[1];
                    if (objAboveGroup || currentGroup == null) {
                        objAboveGroup = true;
                        currentGroup = new ModelGroup(name);
                        this.parts.put(name, currentGroup);
                        currentObject = null;
                    } else {
                        currentObject = new ModelObject(currentGroup.name() + "/" + name);
                        currentGroup.parts.put(name, currentObject);
                    }
                    currentMesh = null;
                    break;
                }
            }
        }
    }

    public static Vector3f parseVector4To3(String[] line) {
        switch (line.length) {
            case 1: {
                return new Vector3f(0.0f, 0.0f, 0.0f);
            }
            case 2: {
                return new Vector3f(Float.parseFloat(line[1]), 0.0f, 0.0f);
            }
            case 3: {
                return new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f);
            }
            case 4: {
                return new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]));
            }
        }
        Vector4f vec4 = OBJModel2.parseVector4(line);
        return new Vector3f(vec4.getX() / vec4.getW(), vec4.getY() / vec4.getW(), vec4.getZ() / vec4.getW());
    }

    public static Vector2f parseVector2(String[] line) {
        switch (line.length) {
            case 1: {
                return new Vector2f(0.0f, 0.0f);
            }
            case 2: {
                return new Vector2f(Float.parseFloat(line[1]), 0.0f);
            }
        }
        return new Vector2f(Float.parseFloat(line[1]), Float.parseFloat(line[2]));
    }

    public static Vector3f parseVector3(String[] line) {
        switch (line.length) {
            case 1: {
                return new Vector3f(0.0f, 0.0f, 0.0f);
            }
            case 2: {
                return new Vector3f(Float.parseFloat(line[1]), 0.0f, 0.0f);
            }
            case 3: {
                return new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f);
            }
        }
        return new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]));
    }

    public static Vector4f parseVector4(String[] line) {
        switch (line.length) {
            case 1: {
                return new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            }
            case 2: {
                return new Vector4f(Float.parseFloat(line[1]), 0.0f, 0.0f, 1.0f);
            }
            case 3: {
                return new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f, 1.0f);
            }
            case 4: {
                return new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), 1.0f);
            }
        }
        return new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), Float.parseFloat(line[4]));
    }

    @Override
    public Collection<? extends IModelGeometryPart> getParts() {
        return this.parts.values();
    }

    @Override
    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.ofNullable(this.parts.get(name));
    }

    private Pair<BakedQuad, Direction> makeQuad(int[][] indices, int tintIndex, Vector4f colorTint, Vector4f ambientColor, boolean isFullbright, TextureAtlasSprite texture, VertexFormat format, Optional<TRSRTransformation> transform) {
        boolean needsNormalRecalculation = false;
        for (int[] ints : indices) {
            needsNormalRecalculation |= ints.length < 3;
        }
        Vector3f faceNormal = new Vector3f(0.0f, 0.0f, 0.0f);
        if (needsNormalRecalculation) {
            Vector3f a = this.positions.get(indices[0][0]);
            Vector3f ab = this.positions.get(indices[1][0]);
            Vector3f ac = this.positions.get(indices[2][0]);
            Vector3f abs = new Vector3f(ab);
            abs.sub((Tuple3f)a);
            Vector3f acs = new Vector3f(ac);
            acs.sub((Tuple3f)a);
            abs.cross(abs, acs);
            abs.normalize();
            faceNormal = abs;
        }
        Vector4f[] pos = new Vector4f[4];
        Vector3f[] norm = new Vector3f[4];
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tintIndex);
        builder.setTexture(texture);
        builder.setApplyDiffuseLighting(!isFullbright);
        Vector2f uv2 = new Vector2f(0.0f, 0.0f);
        if (this.ambientToFullbright) {
            int fakeLight = (int)((ambientColor.getX() + ambientColor.getY() + ambientColor.getZ()) * 15.0f / 3.0f);
            uv2 = new Vector2f((float)(fakeLight << 4) / 32767.0f, (float)(fakeLight << 4) / 32767.0f);
            builder.setApplyDiffuseLighting(fakeLight == 0);
        }
        TRSRTransformation transformation = transform.orElse(null);
        boolean hasTransform = transform.isPresent() && !transform.get().isIdentity();
        for (int i = 0; i < 4; ++i) {
            Vector4f color;
            Vector3f norm0;
            int[] index = indices[Math.min(i, indices.length - 1)];
            Vector3f pos0 = this.positions.get(index[0]);
            Vector4f position = new Vector4f(pos0.x, pos0.y, pos0.z, 1.0f);
            Vector2f texCoord = index.length >= 2 && this.texCoords.size() > 0 ? this.texCoords.get(index[1]) : DEFAULT_COORDS[i];
            Vector3f normal = norm0 = !needsNormalRecalculation && index.length >= 3 && this.normals.size() > 0 ? this.normals.get(index[2]) : faceNormal;
            Vector4f vector4f = color = index.length >= 4 && this.colors.size() > 0 ? this.colors.get(index[3]) : new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
            if (hasTransform) {
                normal = new Vector3f(norm0);
                transformation.transformPosition(position);
                transformation.transformNormal(normal);
            }
            Vector4f tintedColor = new Vector4f(color.getX() * colorTint.getX(), color.getY() * colorTint.getY(), color.getZ() * colorTint.getZ(), color.getW() * colorTint.getW());
            this.putVertexData(builder, format, position, texCoord, normal, tintedColor, uv2, texture);
            pos[i] = position;
            norm[i] = normal;
        }
        builder.setQuadOrientation(Direction.func_176737_a((float)norm[0].x, (float)norm[0].y, (float)norm[0].z));
        Direction cull = null;
        if (this.detectCullableFaces) {
            if (MathHelper.func_180185_a((float)pos[0].getX(), (float)0.0f) && MathHelper.func_180185_a((float)pos[1].getX(), (float)0.0f) && MathHelper.func_180185_a((float)pos[2].getX(), (float)0.0f) && MathHelper.func_180185_a((float)pos[3].getX(), (float)0.0f) && norm[0].getX() < 0.0f) {
                cull = Direction.WEST;
            } else if (MathHelper.func_180185_a((float)pos[0].getX(), (float)1.0f) && MathHelper.func_180185_a((float)pos[1].getX(), (float)1.0f) && MathHelper.func_180185_a((float)pos[2].getX(), (float)1.0f) && MathHelper.func_180185_a((float)pos[3].getX(), (float)1.0f) && norm[0].getX() > 0.0f) {
                cull = Direction.EAST;
            } else if (MathHelper.func_180185_a((float)pos[0].getZ(), (float)0.0f) && MathHelper.func_180185_a((float)pos[1].getZ(), (float)0.0f) && MathHelper.func_180185_a((float)pos[2].getZ(), (float)0.0f) && MathHelper.func_180185_a((float)pos[3].getZ(), (float)0.0f) && norm[0].getZ() < 0.0f) {
                cull = Direction.NORTH;
            } else if (MathHelper.func_180185_a((float)pos[0].getZ(), (float)1.0f) && MathHelper.func_180185_a((float)pos[1].getZ(), (float)1.0f) && MathHelper.func_180185_a((float)pos[2].getZ(), (float)1.0f) && MathHelper.func_180185_a((float)pos[3].getZ(), (float)1.0f) && norm[0].getZ() > 0.0f) {
                cull = Direction.SOUTH;
            } else if (MathHelper.func_180185_a((float)pos[0].getY(), (float)0.0f) && MathHelper.func_180185_a((float)pos[1].getY(), (float)0.0f) && MathHelper.func_180185_a((float)pos[2].getY(), (float)0.0f) && MathHelper.func_180185_a((float)pos[3].getY(), (float)0.0f) && norm[0].getY() < 0.0f) {
                cull = Direction.DOWN;
            } else if (MathHelper.func_180185_a((float)pos[0].getY(), (float)1.0f) && MathHelper.func_180185_a((float)pos[1].getY(), (float)1.0f) && MathHelper.func_180185_a((float)pos[2].getY(), (float)1.0f) && MathHelper.func_180185_a((float)pos[3].getY(), (float)1.0f) && norm[0].getY() > 0.0f) {
                cull = Direction.UP;
            }
        }
        return Pair.of((Object)((Object)builder.build()), cull);
    }

    private void putVertexData(IVertexConsumer consumer, VertexFormat format, Vector4f position0, Vector2f texCoord0, Vector3f normal0, Vector4f color0, Vector2f uv2, TextureAtlasSprite texture) {
        int elementCount = format.func_177345_h();
        block10: for (int j = 0; j < elementCount; ++j) {
            VertexFormatElement e = format.func_177348_c(j);
            switch (e.func_177375_c()) {
                case POSITION: {
                    consumer.put(j, position0.getX(), position0.getY(), position0.getZ(), position0.getW());
                    continue block10;
                }
                case COLOR: {
                    consumer.put(j, color0.getX(), color0.getY(), color0.getZ(), color0.getW());
                    continue block10;
                }
                case UV: {
                    switch (e.func_177369_e()) {
                        case 0: {
                            consumer.put(j, texture.func_94214_a((double)(texCoord0.getX() * 16.0f)), texture.func_94207_b((double)((this.flipV ? 1.0f - texCoord0.getY() : texCoord0.getY()) * 16.0f)));
                            continue block10;
                        }
                        case 1: {
                            consumer.put(j, uv2.x, uv2.y);
                            continue block10;
                        }
                    }
                    consumer.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    consumer.put(j, normal0.getX(), normal0.getY(), normal0.getZ());
                    continue block10;
                }
                default: {
                    consumer.put(j, new float[0]);
                }
            }
        }
    }

    private class ModelMesh {
        @Nullable
        public MaterialLibrary2.Material mat;
        @Nullable
        public String smoothingGroup;
        public final List<int[][]> faces = Lists.newArrayList();

        public ModelMesh(@Nullable MaterialLibrary2.Material currentMat, String currentSmoothingGroup) {
            this.mat = currentMat;
            this.smoothingGroup = currentSmoothingGroup;
        }

        public boolean isFullbright() {
            return this.mat != null && this.mat.ambientColor.epsilonEquals((Tuple4f)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), 0.00390625f);
        }
    }

    public class ModelGroup
    extends ModelObject {
        final Map<String, ModelObject> parts;

        ModelGroup(String name) {
            super(name);
            this.parts = Maps.newHashMap();
        }

        public Collection<? extends IModelGeometryPart> getParts() {
            return this.parts.values();
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
            super.addQuads(owner, modelBuilder, bakery, spriteGetter, sprite, format);
            this.getParts().stream().filter(part -> owner.getPartVisibility((IModelGeometryPart)part)).forEach(part -> part.addQuads(owner, modelBuilder, bakery, spriteGetter, sprite, format));
        }

        @Override
        public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            HashSet combined = Sets.newHashSet();
            combined.addAll(super.getTextureDependencies(owner, modelGetter, missingTextureErrors));
            for (IModelGeometryPart iModelGeometryPart : this.getParts()) {
                combined.addAll(iModelGeometryPart.getTextureDependencies(owner, modelGetter, missingTextureErrors));
            }
            return combined;
        }

        @Override
        public boolean hasAnyFullBright() {
            return super.hasAnyFullBright() || this.parts.values().stream().anyMatch(ModelObject::hasAnyFullBright);
        }
    }

    public class ModelObject
    implements IModelGeometryPart {
        public final String name;
        List<ModelMesh> meshes = Lists.newArrayList();

        ModelObject(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
            for (ModelMesh mesh : this.meshes) {
                boolean isFullbright;
                MaterialLibrary2.Material mat = mesh.mat;
                if (mat == null) continue;
                TextureAtlasSprite texture = spriteGetter.apply(ModelLoaderRegistry2.resolveTexture(mat.diffuseColorMap, owner));
                int tintIndex = mat.diffuseTintIndex;
                Vector4f colorTint = mat.diffuseColor;
                boolean bl = isFullbright = OBJModel2.this.ambientToFullbright && mesh.isFullbright();
                if (format.equals((Object)DefaultVertexFormats.field_176599_b) && isFullbright) {
                    format = DefaultVertexFormats.field_176600_a;
                }
                for (int[][] face : mesh.faces) {
                    Pair quad = OBJModel2.this.makeQuad(face, tintIndex, colorTint, mat.ambientColor, isFullbright, texture, format, sprite.getState().apply(Optional.empty()));
                    if (quad.getRight() == null) {
                        modelBuilder.addGeneralQuad((BakedQuad)quad.getLeft());
                        continue;
                    }
                    modelBuilder.addFaceQuad((Direction)quad.getRight(), (BakedQuad)quad.getLeft());
                }
            }
        }

        @Override
        public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            return this.meshes.stream().map(mesh -> ModelLoaderRegistry2.resolveTexture(mesh.mat.diffuseColorMap, owner)).collect(Collectors.toSet());
        }

        public boolean hasAnyFullBright() {
            return this.meshes.stream().anyMatch(ModelMesh::isFullbright);
        }
    }

    public static class ModelSettings {
        @Nonnull
        public final ResourceLocation modelLocation;
        public final boolean detectCullableFaces;
        public final boolean diffuseLighting;
        public final boolean flipV;
        public final boolean ambientToFullbright;
        @Nullable
        public final String materialLibraryOverrideLocation;

        public ModelSettings(@Nonnull ResourceLocation modelLocation, boolean detectCullableFaces, boolean diffuseLighting, boolean flipV, boolean ambientToFullbright, @Nullable String materialLibraryOverrideLocation) {
            this.modelLocation = modelLocation;
            this.detectCullableFaces = detectCullableFaces;
            this.diffuseLighting = diffuseLighting;
            this.flipV = flipV;
            this.ambientToFullbright = ambientToFullbright;
            this.materialLibraryOverrideLocation = materialLibraryOverrideLocation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelSettings that = (ModelSettings)o;
            return this.equals(that);
        }

        public boolean equals(@Nonnull ModelSettings that) {
            return this.detectCullableFaces == that.detectCullableFaces && this.diffuseLighting == that.diffuseLighting && this.flipV == that.flipV && this.ambientToFullbright == that.ambientToFullbright && this.modelLocation.equals((Object)that.modelLocation) && Objects.equals(this.materialLibraryOverrideLocation, that.materialLibraryOverrideLocation);
        }

        public int hashCode() {
            return Objects.hash(this.modelLocation, this.detectCullableFaces, this.diffuseLighting, this.flipV, this.ambientToFullbright, this.materialLibraryOverrideLocation);
        }
    }
}

