/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import org.apache.commons.lang3.tuple.Pair;

public class LightUtil {
    private static final ConcurrentMap<Pair<VertexFormat, VertexFormat>, int[]> formatMaps = new ConcurrentHashMap<Pair<VertexFormat, VertexFormat>, int[]>();
    private static final VertexFormat DEFAULT_FROM = VertexLighterFlat.withNormal(DefaultVertexFormats.field_176600_a);
    private static final VertexFormat DEFAULT_TO = DefaultVertexFormats.field_176599_b;
    private static final int[] DEFAULT_MAPPING = LightUtil.generateMapping(DEFAULT_FROM, DEFAULT_TO);
    private static IVertexConsumer tessellator = null;
    private static ItemConsumer itemConsumer = null;
    private static final ThreadLocal<ItemPipeline> itemPipeline = ThreadLocal.withInitial(ItemPipeline::new);

    public static float diffuseLight(float x, float y, float z) {
        return Math.min(x * x * 0.6f + y * y * ((3.0f + y) / 4.0f) + z * z * 0.8f, 1.0f);
    }

    public static float diffuseLight(Direction side) {
        switch (side) {
            case DOWN: {
                return 0.5f;
            }
            case UP: {
                return 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
        }
        return 0.6f;
    }

    public static Direction toSide(float x, float y, float z) {
        if (Math.abs(x) > Math.abs(y)) {
            if (Math.abs(x) > Math.abs(z)) {
                if (x < 0.0f) {
                    return Direction.WEST;
                }
                return Direction.EAST;
            }
            if (z < 0.0f) {
                return Direction.NORTH;
            }
            return Direction.SOUTH;
        }
        if (Math.abs(y) > Math.abs(z)) {
            if (y < 0.0f) {
                return Direction.DOWN;
            }
            return Direction.UP;
        }
        if (z < 0.0f) {
            return Direction.NORTH;
        }
        return Direction.SOUTH;
    }

    public static void putBakedQuad(IVertexConsumer consumer, BakedQuad quad) {
        consumer.setTexture(quad.func_187508_a());
        consumer.setQuadOrientation(quad.func_178210_d());
        if (quad.func_178212_b()) {
            consumer.setQuadTint(quad.func_178211_c());
        }
        consumer.setApplyDiffuseLighting(quad.shouldApplyDiffuseLighting());
        float[] data = new float[4];
        VertexFormat formatFrom = consumer.getVertexFormat();
        VertexFormat formatTo = quad.getFormat();
        int countFrom = formatFrom.func_177345_h();
        int countTo = formatTo.func_177345_h();
        int[] eMap = LightUtil.mapFormats(formatFrom, formatTo);
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < countFrom; ++e) {
                if (eMap[e] != countTo) {
                    LightUtil.unpack(quad.func_178209_a(), data, formatTo, v, eMap[e]);
                    consumer.put(e, data);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static int[] mapFormats(VertexFormat from, VertexFormat to) {
        if (from.equals((Object)DEFAULT_FROM) && to.equals((Object)DEFAULT_TO)) {
            return DEFAULT_MAPPING;
        }
        return formatMaps.computeIfAbsent((Pair<VertexFormat, VertexFormat>)Pair.of((Object)from, (Object)to), pair -> LightUtil.generateMapping((VertexFormat)pair.getLeft(), (VertexFormat)pair.getRight()));
    }

    private static int[] generateMapping(VertexFormat from, VertexFormat to) {
        int fromCount = from.func_177345_h();
        int toCount = to.func_177345_h();
        int[] eMap = new int[fromCount];
        for (int e = 0; e < fromCount; ++e) {
            int e2;
            VertexFormatElement expected = from.func_177348_c(e);
            for (e2 = 0; e2 < toCount; ++e2) {
                VertexFormatElement current = to.func_177348_c(e2);
                if (expected.func_177375_c() == current.func_177375_c() && expected.func_177369_e() == current.func_177369_e()) break;
            }
            eMap[e] = e2;
        }
        return eMap;
    }

    public static void unpack(int[] from, float[] to, VertexFormat formatFrom, int v, int e) {
        int length = 4 < to.length ? 4 : to.length;
        VertexFormatElement element = formatFrom.func_177348_c(e);
        int vertexStart = v * formatFrom.func_177338_f() + formatFrom.func_181720_d(e);
        int count = element.func_177370_d();
        VertexFormatElement.Type type = element.func_177367_b();
        int size = type.func_177395_a();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < length; ++i) {
            if (i < count) {
                int pos = vertexStart + size * i;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + size - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                bits &= mask;
                if (type == VertexFormatElement.Type.FLOAT) {
                    to[i] = Float.intBitsToFloat(bits);
                    continue;
                }
                if (type == VertexFormatElement.Type.UBYTE || type == VertexFormatElement.Type.USHORT) {
                    to[i] = (float)bits / (float)mask;
                    continue;
                }
                if (type == VertexFormatElement.Type.UINT) {
                    to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                    continue;
                }
                if (type == VertexFormatElement.Type.BYTE) {
                    to[i] = (float)((byte)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type == VertexFormatElement.Type.SHORT) {
                    to[i] = (float)((short)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type != VertexFormatElement.Type.INT) continue;
                to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 2.147483647E9);
                continue;
            }
            to[i] = 0.0f;
        }
    }

    public static void pack(float[] from, int[] to, VertexFormat formatTo, int v, int e) {
        VertexFormatElement element = formatTo.func_177348_c(e);
        int vertexStart = v * formatTo.func_177338_f() + formatTo.func_181720_d(e);
        int count = element.func_177370_d();
        VertexFormatElement.Type type = element.func_177367_b();
        int size = type.func_177395_a();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < 4; ++i) {
            float f;
            if (i >= count) continue;
            int pos = vertexStart + size * i;
            int index = pos >> 2;
            int offset = pos & 3;
            int bits = 0;
            float f2 = f = i < from.length ? from[i] : 0.0f;
            bits = type == VertexFormatElement.Type.FLOAT ? Float.floatToRawIntBits(f) : (type == VertexFormatElement.Type.UBYTE || type == VertexFormatElement.Type.USHORT || type == VertexFormatElement.Type.UINT ? Math.round(f * (float)mask) : Math.round(f * (float)(mask >> 1)));
            int n = index;
            to[n] = to[n] & ~(mask << offset * 8);
            int n2 = index;
            to[n2] = to[n2] | (bits & mask) << offset * 8;
        }
    }

    @Deprecated
    public static IVertexConsumer getTessellator() {
        if (tessellator == null) {
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder wr = tes.func_178180_c();
            tessellator = new VertexBufferConsumer(wr);
        }
        return tessellator;
    }

    @Deprecated
    public static ItemConsumer getItemConsumer() {
        if (itemConsumer == null) {
            itemConsumer = new ItemConsumer(LightUtil.getTessellator());
        }
        return itemConsumer;
    }

    public static void renderQuadColorSlow(BufferBuilder buffer, BakedQuad quad, int auxColor) {
        ItemPipeline pipeline = itemPipeline.get();
        pipeline.bufferConsumer.setBuffer(buffer);
        ItemConsumer cons = pipeline.itemConsumer;
        float b = (float)(auxColor & 0xFF) / 255.0f;
        float g = (float)(auxColor >>> 8 & 0xFF) / 255.0f;
        float r = (float)(auxColor >>> 16 & 0xFF) / 255.0f;
        float a = (float)(auxColor >>> 24 & 0xFF) / 255.0f;
        cons.setAuxColor(r, g, b, a);
        quad.pipe((IVertexConsumer)cons);
    }

    public static void renderQuadColor(BufferBuilder buffer, BakedQuad quad, int auxColor) {
        if (quad.getFormat().equals((Object)buffer.func_178973_g())) {
            buffer.func_178981_a(quad.func_178209_a());
            if (buffer.func_178973_g().func_207752_d()) {
                ForgeHooksClient.putQuadColor(buffer, quad, auxColor);
            }
        } else {
            LightUtil.renderQuadColorSlow(buffer, quad, auxColor);
        }
    }

    public static class ItemConsumer
    extends VertexTransformer {
        private int vertices = 0;
        private float[] auxColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private float[] buf = new float[4];

        public ItemConsumer(IVertexConsumer parent) {
            super(parent);
        }

        public void setAuxColor(float ... auxColor) {
            System.arraycopy(auxColor, 0, this.auxColor, 0, this.auxColor.length);
        }

        @Override
        public void put(int element, float ... data) {
            if (this.getVertexFormat().func_177348_c(element).func_177375_c() == VertexFormatElement.Usage.COLOR) {
                System.arraycopy(this.auxColor, 0, this.buf, 0, this.buf.length);
                int n = Math.min(4, data.length);
                for (int i = 0; i < n; ++i) {
                    int n2 = i;
                    this.buf[n2] = this.buf[n2] * data[i];
                }
                super.put(element, this.buf);
            } else {
                super.put(element, data);
            }
            if (element == this.getVertexFormat().func_177345_h() - 1) {
                ++this.vertices;
                if (this.vertices == 4) {
                    this.vertices = 0;
                }
            }
        }
    }

    private static final class ItemPipeline {
        final VertexBufferConsumer bufferConsumer = new VertexBufferConsumer();
        final ItemConsumer itemConsumer = new ItemConsumer(this.bufferConsumer);

        ItemPipeline() {
        }
    }
}

